/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import com.inversoft.rest.ClientResponse;
import io.fusionauth.client.FusionAuthClient;
import io.fusionauth.domain.RefreshTokenExpirationPolicy;
import io.fusionauth.domain.RefreshTokenRevocationPolicy;
import io.fusionauth.domain.RefreshTokenUsagePolicy;
import io.fusionauth.domain.RememberPreviousPasswords;
import io.fusionauth.domain.SecureGeneratorConfiguration;
import io.fusionauth.domain.SecureGeneratorType;
import io.fusionauth.domain.Tenant;
import io.fusionauth.domain.api.TenantRequest;
import io.fusionauth.load.Configuration;
import io.fusionauth.load.FusionAuthBaseWorker;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class FusionAuthCreateTenantWorker
extends FusionAuthBaseWorker {
    private final AtomicInteger counter;

    public FusionAuthCreateTenantWorker(FusionAuthClient client, Configuration configuration, AtomicInteger counter) {
        super(client, configuration);
        this.counter = counter;
    }

    @Override
    public boolean execute() {
        this.setTenantIndex(this.counter.incrementAndGet());
        RememberPreviousPasswords rememberPreviousPasswords = new RememberPreviousPasswords();
        rememberPreviousPasswords.enabled = true;
        rememberPreviousPasswords.count = 100;
        Tenant tenant = (Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)((Tenant)new Tenant().with(t -> {
            t.name = "tenant_" + this.tenantIndex;
        })).with(t -> {
            t.emailConfiguration.verifyEmail = false;
        })).with(t -> {
            t.emailConfiguration.host = "localhost";
        })).with(t -> {
            t.emailConfiguration.port = 25;
        })).with(t -> {
            t.externalIdentifierConfiguration.authorizationGrantIdTimeToLiveInSeconds = 60;
        })).with(t -> {
            t.externalIdentifierConfiguration.changePasswordIdGenerator = new SecureGeneratorConfiguration(10, SecureGeneratorType.randomAlphaNumeric);
        })).with(t -> {
            t.externalIdentifierConfiguration.changePasswordIdTimeToLiveInSeconds = 60;
        })).with(t -> {
            t.externalIdentifierConfiguration.deviceCodeTimeToLiveInSeconds = 60;
        })).with(t -> {
            t.externalIdentifierConfiguration.deviceUserCodeIdGenerator = new SecureGeneratorConfiguration(10, SecureGeneratorType.randomAlphaNumeric);
        })).with(t -> {
            t.externalIdentifierConfiguration.emailVerificationIdGenerator = new SecureGeneratorConfiguration(10, SecureGeneratorType.randomAlphaNumeric);
        })).with(t -> {
            t.externalIdentifierConfiguration.emailVerificationIdTimeToLiveInSeconds = 100000000;
        })).with(t -> {
            t.externalIdentifierConfiguration.externalAuthenticationIdTimeToLiveInSeconds = 60;
        })).with(t -> {
            t.externalIdentifierConfiguration.oneTimePasswordTimeToLiveInSeconds = 60;
        })).with(t -> {
            t.externalIdentifierConfiguration.passwordlessLoginGenerator = new SecureGeneratorConfiguration(10, SecureGeneratorType.randomAlphaNumeric);
        })).with(t -> {
            t.externalIdentifierConfiguration.passwordlessLoginTimeToLiveInSeconds = 60;
        })).with(t -> {
            t.externalIdentifierConfiguration.registrationVerificationIdGenerator = new SecureGeneratorConfiguration(10, SecureGeneratorType.randomAlphaNumeric);
        })).with(t -> {
            t.externalIdentifierConfiguration.registrationVerificationIdTimeToLiveInSeconds = 60;
        })).with(t -> {
            t.externalIdentifierConfiguration.samlv2AuthNRequestIdTimeToLiveInSeconds = 60;
        })).with(t -> {
            t.externalIdentifierConfiguration.setupPasswordIdGenerator = new SecureGeneratorConfiguration(10, SecureGeneratorType.randomAlphaNumeric);
        })).with(t -> {
            t.externalIdentifierConfiguration.setupPasswordIdTimeToLiveInSeconds = 60;
        })).with(t -> {
            t.externalIdentifierConfiguration.twoFactorIdTimeToLiveInSeconds = 60;
        })).with(t -> {
            t.externalIdentifierConfiguration.twoFactorTrustIdTimeToLiveInSeconds = 60;
        })).with(t -> {
            t.issuer = "example.com";
        })).with(t -> {
            t.jwtConfiguration.accessTokenKeyId = UUID.fromString(this.configuration.getString("keyId"));
        })).with(t -> {
            t.jwtConfiguration.idTokenKeyId = UUID.fromString(this.configuration.getString("keyId"));
        })).with(t -> {
            t.jwtConfiguration.refreshTokenExpirationPolicy = RefreshTokenExpirationPolicy.Fixed;
        })).with(t -> {
            t.jwtConfiguration.refreshTokenRevocationPolicy = new RefreshTokenRevocationPolicy(true, true);
        })).with(t -> {
            t.jwtConfiguration.refreshTokenTimeToLiveInMinutes = 60;
        })).with(t -> {
            t.jwtConfiguration.refreshTokenUsagePolicy = RefreshTokenUsagePolicy.OneTimeUse;
        })).with(t -> {
            t.jwtConfiguration.timeToLiveInSeconds = 60;
        })).with(t -> {
            t.passwordValidationRules.rememberPreviousPasswords = rememberPreviousPasswords;
        })).with(t -> {
            t.passwordValidationRules.maxLength = 200;
        })).with(t -> {
            t.passwordValidationRules.minLength = 10;
        })).with(t -> {
            t.passwordValidationRules.requireMixedCase = false;
        })).with(t -> {
            t.passwordValidationRules.requireNonAlpha = false;
        })).with(t -> {
            t.passwordValidationRules.requireNumber = false;
        })).with(t -> {
            t.passwordValidationRules.validateOnLogin = false;
        })).with(t -> {
            t.themeId = UUID.fromString(this.configuration.getString("themeId"));
        });
        ClientResponse result = this.client.createTenant(this.tenantId, new TenantRequest(null, tenant, null));
        if (result.wasSuccessful()) {
            return true;
        }
        this.printErrors(result);
        return false;
    }
}

