/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load.listeners;

import io.fusionauth.load.CSVSampleListener;
import io.fusionauth.load.Configuration;
import io.fusionauth.load.ConfigurationInjected;
import io.fusionauth.load.LoadTools;
import io.fusionauth.load.Sample;
import io.fusionauth.load.SampleListener;
import io.fusionauth.load.ThrowingConsumer;
import java.io.BufferedWriter;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ThroughputListener
implements SampleListener,
CSVSampleListener {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private long failures;
    private int multiplier;
    private Instant start;
    private Instant stop;
    private long successes;
    private long totalLatency;

    @ConfigurationInjected
    public ThroughputListener(Configuration configuration) {
        this.multiplier = configuration.getInteger("multiplier", 1);
    }

    @Override
    public void done() {
        this.stop = Instant.now();
    }

    @Override
    public void handle(Sample sample) {
        LoadTools.writeLock(this.lock, () -> {
            if (this.start == null) {
                this.start = Instant.now();
            }
            if (sample.succeeded) {
                ++this.successes;
            } else {
                ++this.failures;
            }
            this.totalLatency += sample.duration().toMillis();
        });
    }

    @Override
    public String outputFileName() {
        return "throughputListenerResults";
    }

    @Override
    public void report(BufferedWriter writer) throws Exception {
        this.buildReport(totals -> {
            writer.write(String.valueOf(totals.duration.toMillis()) + "," + String.valueOf(totals.total) + "," + totals.df.format(totals.averageLatency) + "," + totals.df.format(totals.averageSuccesses) + "," + totals.df.format(totals.averageFailures));
            writer.newLine();
        });
    }

    @Override
    public void report(Appendable writer) throws Exception {
        this.buildReport(totals -> writer.append("\nThroughput Report\n").append(" Total duration:\t" + totals.duration.toMillis() + " ms (~" + TimeUnit.MILLISECONDS.toSeconds(totals.duration.toMillis()) + " s)\n").append(" Total count:\t\t" + totals.total + "\n").append(" Avg. latency:\t\t" + totals.df.format(totals.averageLatency) + " ms\n").append(" Avg. success:\t\t" + totals.df.format(totals.averageSuccesses) + " per second\n").append(" Avg. failure:\t\t" + (String)(totals.averageFailures == 0.0 ? "-" : totals.df.format(totals.averageFailures) + " per second\n")));
    }

    @Override
    public void reportHeader(BufferedWriter writer) throws Exception {
        writer.write("Total Duration, Total Count, Average Latency, Average Success, Average Failures");
        writer.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildReport(ThrowingConsumer<Totals> consumer) throws Exception {
        double averageLatency;
        double averageSuccesses;
        double averageFailures;
        long total;
        Duration duration;
        this.lock.readLock().lock();
        try {
            Instant end = this.stop != null ? this.stop : Instant.now();
            duration = Duration.between(this.start, end);
            total = (this.failures + this.successes) * (long)this.multiplier;
            long currentFailures = this.failures * (long)this.multiplier;
            long currentSuccesses = this.successes * (long)this.multiplier;
            averageFailures = (double)currentFailures / ((double)duration.toMillis() / 1000.0);
            averageSuccesses = (double)currentSuccesses / ((double)duration.toMillis() / 1000.0);
            averageLatency = (double)this.totalLatency / (double)total;
        }
        finally {
            this.lock.readLock().unlock();
        }
        DecimalFormat df = new DecimalFormat("#.###");
        df.setRoundingMode(RoundingMode.CEILING);
        consumer.accept(new Totals(averageLatency, averageSuccesses, averageFailures, total, duration, df));
    }

    private static class Totals {
        double averageFailures;
        double averageLatency;
        double averageSuccesses;
        DecimalFormat df;
        Duration duration;
        long total;

        Totals(double averageLatency, double averageSuccesses, double averageFailures, long total, Duration duration, DecimalFormat df) {
            this.averageLatency = averageLatency;
            this.averageSuccesses = averageSuccesses;
            this.averageFailures = averageFailures;
            this.total = total;
            this.duration = duration;
            this.df = df;
        }
    }
}

