/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load.listeners;

import io.fusionauth.load.CSVSampleListener;
import io.fusionauth.load.Sample;
import io.fusionauth.load.SampleListener;
import io.fusionauth.load.ThrowingConsumer;
import java.io.BufferedWriter;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CountListener
implements SampleListener,
CSVSampleListener {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private long failures;
    private long successes;
    private long totals;

    @Override
    public void done() {
    }

    @Override
    public void handle(Sample sample) {
        this.lock.writeLock().lock();
        try {
            if (sample.succeeded) {
                ++this.successes;
            } else {
                ++this.failures;
            }
            ++this.totals;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public String outputFileName() {
        return "countListenerResults";
    }

    @Override
    public void report(BufferedWriter writer) throws Exception {
        this.buildReport(totals -> {
            writer.write(totals.currentSuccesses + "," + totals.currentFailures + "," + totals.currentTotals);
            writer.newLine();
        });
    }

    @Override
    public void report(Appendable writer) throws Exception {
        this.buildReport(totals -> writer.append("Successes: " + totals.currentSuccesses + "\n").append("Failures: " + totals.currentFailures + "\n").append("Totals: " + totals.currentTotals + "\n"));
    }

    @Override
    public void reportHeader(BufferedWriter writer) throws Exception {
        writer.write("Successes, Failures, Totals");
        writer.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildReport(ThrowingConsumer<Totals> consumer) throws Exception {
        long currentTotals;
        long currentFailures;
        long currentSuccesses;
        this.lock.readLock().lock();
        try {
            currentSuccesses = this.successes;
            currentFailures = this.failures;
            currentTotals = this.totals;
        }
        finally {
            this.lock.readLock().unlock();
        }
        consumer.accept(new Totals(currentSuccesses, currentFailures, currentTotals));
    }

    private static class Totals {
        long currentFailures;
        long currentSuccesses;
        long currentTotals;

        Totals(long currentSuccesses, long currentFailures, long currentTotals) {
            this.currentSuccesses = currentSuccesses;
            this.currentFailures = currentFailures;
            this.currentTotals = currentTotals;
        }
    }
}

