/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import io.fusionauth.load.Sample;
import io.fusionauth.load.SampleListener;
import io.fusionauth.load.Worker;
import java.time.Instant;
import java.util.Collection;
import java.util.stream.IntStream;

public class WorkerExecutor
implements Runnable {
    public final Collection<SampleListener> listeners;
    public final int loopCount;
    public final Worker worker;

    public WorkerExecutor(Worker worker, int loopCount, Collection<SampleListener> listeners) {
        this.worker = worker;
        this.loopCount = loopCount;
        this.listeners = listeners;
    }

    @Override
    public void run() {
        IntStream.range(0, this.loopCount).forEachOrdered(n -> {
            this.worker.prepare();
            Instant start = Instant.now();
            boolean success = this.worker.execute();
            Instant stop = Instant.now();
            Sample sample = new Sample(success, start, stop);
            this.listeners.forEach(l -> l.handle(sample));
        });
        this.worker.finished();
    }
}

