/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import com.inversoft.rest.ClientResponse;
import io.fusionauth.client.FusionAuthClient;
import io.fusionauth.domain.api.StatusResponse;
import io.fusionauth.load.Configuration;
import io.fusionauth.load.ConfigurationInjected;
import io.fusionauth.load.ElasticsearchWorker;
import io.fusionauth.load.FusionAuthCreateApplicationWorker;
import io.fusionauth.load.FusionAuthCreateTenantWorker;
import io.fusionauth.load.FusionAuthEmailVerificationIdWorker;
import io.fusionauth.load.FusionAuthLoginWorker;
import io.fusionauth.load.FusionAuthOAuth2AuthorizeWorker;
import io.fusionauth.load.FusionAuthRefreshWorker;
import io.fusionauth.load.FusionAuthRegistrationWorker;
import io.fusionauth.load.FusionAuthRetrieveEmailWorker;
import io.fusionauth.load.FusionAuthSearchDataWorker;
import io.fusionauth.load.FusionAuthSearchWorker;
import io.fusionauth.load.FusionAuthSimpleGetWorker;
import io.fusionauth.load.FusionAuthUpdatePasswordWorker;
import io.fusionauth.load.FusionAuthUserImportWorker;
import io.fusionauth.load.LoadDefinition;
import io.fusionauth.load.Worker;
import io.fusionauth.load.WorkerFactory;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class FusionAuthWorkerFactory
implements WorkerFactory {
    private static final AtomicInteger counter = new AtomicInteger(-1);
    private final FusionAuthClient client;
    private final Configuration configuration;
    private final String directive;

    @ConfigurationInjected
    public FusionAuthWorkerFactory(Configuration configuration) {
        String apiKey = configuration.getString("apiKey", null);
        String tenantId = configuration.getString("tenantId", null);
        String url = configuration.getString("url", null);
        if (apiKey != null && url != null) {
            this.client = new FusionAuthClient(apiKey, url, 5000, 10000);
            if (tenantId != null) {
                this.client.setTenantId(UUID.fromString(tenantId));
            }
        } else {
            this.client = null;
        }
        this.configuration = configuration;
        this.directive = configuration.getString("directive", "register");
        if (counter.intValue() == -1) {
            counter.set(configuration.getInteger("counter", 0));
        }
    }

    @Override
    public Worker createWorker() {
        return switch (this.directive) {
            case "create-application" -> new FusionAuthCreateApplicationWorker(this.client, this.configuration, counter);
            case "create-tenant" -> new FusionAuthCreateTenantWorker(this.client, this.configuration, counter);
            case "email-verification" -> new FusionAuthEmailVerificationIdWorker(this.client, this.configuration, counter);
            case "simple-get" -> new FusionAuthSimpleGetWorker(this.configuration);
            case "login" -> new FusionAuthLoginWorker(this.client, this.configuration);
            case "update-password" -> new FusionAuthUpdatePasswordWorker(this.client, this.configuration);
            case "oauth2/authorize" -> new FusionAuthOAuth2AuthorizeWorker(this.client, this.configuration);
            case "refresh" -> new FusionAuthRefreshWorker(this.client, this.configuration);
            case "register" -> new FusionAuthRegistrationWorker(this.client, this.configuration, counter);
            case "search" -> new FusionAuthSearchWorker(this.client, this.configuration);
            case "search-data" -> new FusionAuthSearchDataWorker(this.client, this.configuration);
            case "retrieve-email" -> new FusionAuthRetrieveEmailWorker(this.client, this.configuration);
            case "user-import" -> new FusionAuthUserImportWorker(this.client, this.configuration, counter);
            case "elasticsearch" -> new ElasticsearchWorker(this.configuration);
            default -> throw new IllegalArgumentException("Invalid directive [" + this.directive + "]");
        };
    }

    @Override
    public void prepare(LoadDefinition loadDefinition) {
        String directive = null;
        String url = null;
        String apiKey = null;
        if (loadDefinition != null && loadDefinition.workerFactory != null) {
            directive = loadDefinition.workerFactory.getString("directive", null);
            url = loadDefinition.workerFactory.getString("url", null);
            apiKey = loadDefinition.workerFactory.getString("apiKey", null);
        }
        System.out.println("  --> Worker directive:\t" + directive);
        System.out.println("  --> Worker url:\t" + url);
        System.out.println("  --> Target version:\t" + this.fetchVersion(url, apiKey));
    }

    protected String fetchVersion(String url, String apiKey) {
        FusionAuthClient client;
        ClientResponse response;
        if (apiKey != null && url != null && (response = (client = new FusionAuthClient(apiKey, url, 5000, 10000)).retrieveSystemStatusUsingAPIKey()).wasSuccessful() && response.successResponse != null) {
            return ((StatusResponse)response.successResponse).getOrDefault((Object)"version", (Object)"unavailable").toString();
        }
        return "unavailable";
    }
}

