/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import com.inversoft.rest.ClientResponse;
import io.fusionauth.client.FusionAuthClient;
import io.fusionauth.domain.api.user.SearchRequest;
import io.fusionauth.domain.search.UserSearchCriteria;
import io.fusionauth.load.BaseWorker;
import io.fusionauth.load.Configuration;
import java.util.Random;

public class FusionAuthSearchWorker
extends BaseWorker {
    private final FusionAuthClient client;
    private final int loginLowerBound;
    private final int loginUpperBound;
    private final int numberOfResults;
    private final String queryString;

    public FusionAuthSearchWorker(FusionAuthClient client, Configuration configuration) {
        super(configuration);
        this.client = client;
        this.numberOfResults = configuration.getInteger("numberOfResults");
        this.queryString = configuration.getString("queryString");
        this.loginLowerBound = configuration.getInteger("loginLowerBound", 0);
        this.loginUpperBound = configuration.getInteger("loginUpperBound", 1000000);
    }

    @Override
    public boolean execute() {
        int random = new Random().nextInt(this.loginUpperBound - this.loginLowerBound + 1) + this.loginLowerBound;
        String email = "load_user_" + random + "@fusionauth.io";
        String query = this.queryString.replace("${email}", email);
        ClientResponse result = this.client.searchUsersByQuery(new SearchRequest((UserSearchCriteria)((UserSearchCriteria)new UserSearchCriteria().with(c -> {
            c.numberOfResults = this.numberOfResults;
        })).with(c -> {
            c.queryString = query;
        })));
        if (result.wasSuccessful()) {
            return true;
        }
        this.printErrors(result);
        return false;
    }
}

