/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import com.inversoft.rest.ClientResponse;
import io.fusionauth.client.FusionAuthClient;
import io.fusionauth.domain.api.user.SearchRequest;
import io.fusionauth.domain.search.UserSearchCriteria;
import io.fusionauth.load.BaseWorker;
import io.fusionauth.load.Configuration;
import java.util.List;

public class FusionAuthSearchDataWorker
extends BaseWorker {
    private final FusionAuthClient client;
    private final List<String> externalIds = List.of();
    private final int numberOfResults;
    private final String query;
    private final String queryString;

    public FusionAuthSearchDataWorker(FusionAuthClient client, Configuration configuration) {
        super(configuration);
        this.client = client;
        this.numberOfResults = configuration.getInteger("numberOfResults");
        this.queryString = configuration.getString("queryString");
        this.query = configuration.getString("query");
    }

    @Override
    public boolean execute() {
        String externalId = FusionAuthSearchDataWorker.secureString(20, "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
        ClientResponse result = this.client.searchUsersByQuery(new SearchRequest((UserSearchCriteria)((UserSearchCriteria)new UserSearchCriteria().with(c -> {
            c.numberOfResults = this.numberOfResults;
        })).with(c -> {
            c.queryString = this.queryString.replace("${externalId}", externalId);
        })));
        if (result.wasSuccessful()) {
            return true;
        }
        this.printErrors(result);
        return false;
    }
}

