/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load.http;

import com.inversoft.rest.ByteArrayBodyHandler;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;

public class ChunkedBodyHandler
extends ByteArrayBodyHandler {
    private int chunkSize = 1024;

    public ChunkedBodyHandler(String body) {
        super(body.getBytes(StandardCharsets.UTF_8));
    }

    public void setHeaders(HttpURLConnection huc) {
        if (this.chunkSize == 0) {
            throw new IllegalStateException("chunkSize must be greater than 0");
        }
        huc.setChunkedStreamingMode(this.chunkSize);
    }

    public ChunkedBodyHandler withChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }
}

