/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import com.inversoft.rest.ClientResponse;
import com.inversoft.rest.RESTClient;
import com.inversoft.rest.TextResponseHandler;
import io.fusionauth.load.BaseWorker;
import io.fusionauth.load.Configuration;
import io.fusionauth.load.http.ChunkedBodyHandler;
import io.fusionauth.load.http.FixedLengthRequestHandler;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.Executors;

public class JavaHTTPLoadTestWorker
extends BaseWorker {
    private final String body = "This is a small body for a load test request.";
    private final byte[] bodyBytes = "This is a small body for a load test request.".getBytes(StandardCharsets.UTF_8);
    private final boolean chunked;
    private final HttpClient javaRESTClient;
    private final String restClient;
    private final String url;

    public JavaHTTPLoadTestWorker(Configuration configuration) {
        super(configuration);
        this.url = configuration.getString("url");
        this.chunked = configuration.getBoolean("chunked", false);
        this.restClient = configuration.getString("restClient", "restify");
        if (!this.restClient.equals("restify") && !this.restClient.equals("java")) {
            throw new IllegalArgumentException("Invalid restClient: " + this.restClient + ". Must be 'restify' or 'java'");
        }
        this.javaRESTClient = this.restClient.equals("java") ? HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).executor(Executors.newVirtualThreadPerTaskExecutor()).followRedirects(HttpClient.Redirect.ALWAYS).build() : null;
    }

    @Override
    public boolean execute() {
        if ("restify".equals(this.restClient)) {
            ClientResponse response = new RESTClient(String.class, String.class).url(this.url).setHeader("Content-Type", "text/plain").bodyHandler((RESTClient.BodyHandler)(this.chunked ? new ChunkedBodyHandler("This is a small body for a load test request.") : new FixedLengthRequestHandler("This is a small body for a load test request."))).connectTimeout(15000).readTimeout(15000).successResponseHandler((RESTClient.ResponseHandler)new TextResponseHandler()).errorResponseHandler((RESTClient.ResponseHandler)new TextResponseHandler()).get().go();
            if (response.wasSuccessful()) {
                return true;
            }
            if (response.exception != null) {
                System.out.println(response.exception.getClass().getSimpleName() + " [" + response.exception.getMessage() + "]");
            } else {
                System.out.println(response.status);
                System.out.println((String)response.errorResponse);
            }
            return false;
        }
        if ("java".equals(this.restClient)) {
            HttpRequest.BodyPublisher publisher = this.chunked ? HttpRequest.BodyPublishers.ofInputStream(() -> new ByteArrayInputStream(this.bodyBytes)) : HttpRequest.BodyPublishers.ofByteArray(this.bodyBytes);
            HttpRequest request = HttpRequest.newBuilder().method("GET", publisher).timeout(Duration.ofSeconds(10L)).uri(URI.create(this.url)).build();
            try {
                HttpResponse<byte[]> response = this.javaRESTClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
                return response.statusCode() >= 200 && response.statusCode() <= 399;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }
}

