/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import com.fasterxml.jackson.databind.JsonNode;
import com.inversoft.rest.ByteArrayBodyHandler;
import com.inversoft.rest.ClientResponse;
import com.inversoft.rest.JSONResponseHandler;
import com.inversoft.rest.RESTClient;
import io.fusionauth.load.BaseWorker;
import io.fusionauth.load.Configuration;
import java.nio.charset.StandardCharsets;
import java.util.Random;

public class ElasticsearchWorker
extends BaseWorker {
    private final String indexName;
    private final int loginLowerBound;
    private final int loginUpperBound;
    private final String queryString;
    private final String url;

    public ElasticsearchWorker(Configuration configuration) {
        super(configuration);
        this.queryString = configuration.getString("queryString");
        this.loginLowerBound = configuration.getInteger("loginLowerBound", 0);
        this.loginUpperBound = configuration.getInteger("loginUpperBound", 1000000);
        this.indexName = configuration.getString("indexName", null);
        this.url = configuration.getString("url", null);
    }

    @Override
    public boolean execute() {
        int random = new Random().nextInt(this.loginUpperBound - this.loginLowerBound + 1) + this.loginLowerBound;
        String email = "load_user_" + random + "@fusionauth.io";
        String query = this.queryString.replace("${email}", email);
        ClientResponse response = new RESTClient(JsonNode.class, JsonNode.class).url(this.url + "/" + this.indexName + "/_search/").bodyHandler((RESTClient.BodyHandler)new ByteArrayBodyHandler("{\n  \"query\": {\n    \"query_string\": {\n      \"query\": \"${query}\"\n    }\n  }\n}\n".replace("${query}", query).getBytes(StandardCharsets.UTF_8))).setHeader("Content-Type", "application/json").connectTimeout(2000).readTimeout(2000).successResponseHandler((RESTClient.ResponseHandler)new JSONResponseHandler(JsonNode.class)).errorResponseHandler((RESTClient.ResponseHandler)new JSONResponseHandler(JsonNode.class)).get().go();
        if (!response.wasSuccessful()) {
            System.out.println(response.errorResponse);
        }
        return response.wasSuccessful();
    }
}

