/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import io.fusionauth.load.Configuration;
import io.fusionauth.load.ConfigurationInjected;
import io.fusionauth.load.JavaHTTPLoadTestWorker;
import io.fusionauth.load.LoadDefinition;
import io.fusionauth.load.Worker;
import io.fusionauth.load.WorkerFactory;

public class HTTPWorkerFactory
implements WorkerFactory {
    private final Configuration configuration;
    private final String directive;

    @ConfigurationInjected
    public HTTPWorkerFactory(Configuration configuration) {
        this.configuration = configuration;
        this.directive = configuration.getString("directive", "java-http-load-test");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Worker createWorker() {
        switch (this.directive) {
            case "java-http-load-test": {
                return new JavaHTTPLoadTestWorker(this.configuration);
            }
            default: {
                throw new IllegalArgumentException("Invalid directive [" + this.directive + "]");
            }
        }
    }

    @Override
    public void prepare(LoadDefinition loadDefinition) {
    }
}

