/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import com.inversoft.rest.ClientResponse;
import io.fusionauth.client.FusionAuthClient;
import io.fusionauth.load.BaseWorker;
import io.fusionauth.load.Configuration;
import java.util.Random;

public class FusionAuthRetrieveEmailWorker
extends BaseWorker {
    private final FusionAuthClient client;
    private final int loginLowerBound;
    private final int loginUpperBound;

    public FusionAuthRetrieveEmailWorker(FusionAuthClient client, Configuration configuration) {
        super(configuration);
        this.client = client;
        this.loginLowerBound = configuration.getInteger("loginLowerBound", 0);
        this.loginUpperBound = configuration.getInteger("loginUpperBound", 1000000);
    }

    @Override
    public boolean execute() {
        int random = new Random().nextInt(this.loginUpperBound - this.loginLowerBound + 1) + this.loginLowerBound;
        String email = "load_user_" + random + "@fusionauth.io";
        ClientResponse result = this.client.retrieveUserByEmail(email);
        if (result.wasSuccessful()) {
            return true;
        }
        this.printErrors(result);
        return false;
    }
}

