/*
 * Copyright (c) 2023-2025, FusionAuth, All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package io.fusionauth.load;

import java.util.Random;

import com.inversoft.error.Errors;
import com.inversoft.rest.ClientResponse;
import io.fusionauth.client.FusionAuthClient;
import io.fusionauth.domain.api.UserResponse;

/**
 * Worker to test retrieving user by email address.
 *
 * @author Spencer Witt
 */
public class FusionAuthRetrieveEmailWorker extends BaseWorker {
  private final FusionAuthClient client;

  private final int loginLowerBound;

  private final int loginUpperBound;

  public FusionAuthRetrieveEmailWorker(FusionAuthClient client, Configuration configuration) {
    super(configuration);
    this.client = client;
    this.loginLowerBound = configuration.getInteger("loginLowerBound", 0);
    this.loginUpperBound = configuration.getInteger("loginUpperBound", 1_000_000);
  }

  @Override
  public boolean execute() {
    int random = new Random().nextInt((loginUpperBound - loginLowerBound) + 1) + loginLowerBound;
    String email = "load_user_" + random + "@fusionauth.io";

    ClientResponse<UserResponse, Errors> result = client.retrieveUserByEmail(email);
    if (result.wasSuccessful()) {
      return true;
    }

    printErrors(result);
    return false;
  }
}
