/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.security;

import io.fusionauth.jwt.JWTUtils;
import io.fusionauth.pem.domain.PEM;
import io.fusionauth.security.KeyUtils;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.util.Base64;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class KeyUtilsTests {
    @DataProvider(name="ecKeyLengths")
    public Object[][] ecKeyLengths() {
        return new Object[][]{{"EC", 256, 256, 256}, {"EC", 384, 384, 384}, {"EC", 521, 521, 521}};
    }

    @DataProvider(name="rsaKeyLengths")
    public Object[][] rsaKeyLengths() {
        return new Object[][]{{"RSA", 2048, 2048, 2048}, {"RSA", 3072, 3072, 3072}, {"RSA", 4096, 4096, 4096}};
    }

    @Test
    public void problematicKey() {
        PublicKey key = PEM.decode((String)"-----BEGIN PUBLIC KEY-----\nMHYwEAYHKoZIzj0CAQYFK4EEACIDYgAEABGGbHRp5Rv+sm86OfuPqnkYCmUzuUDW\nfJPXIgZUeqo7JY5mTALqdMYYi93rh0xpkLzFrwZGSYv8gGwR9t5d3901L0CZuX6X\nHob0RbKzwdAEdykcBPxpar7k8jVGCo8m\n-----END PUBLIC KEY-----").publicKey;
        Assert.assertEquals((int)KeyUtils.getKeyLength((Key)key), (int)384);
    }

    @Test(dataProvider="ecKeyLengths", invocationCount=500)
    public void ec_getKeyLength(String algorithm, int keySize, int privateKeySize, int publicKeySize) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
        keyPairGenerator.initialize(keySize);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        Assert.assertEquals((int)KeyUtils.getKeyLength((Key)keyPair.getPrivate()), (int)privateKeySize);
        Assert.assertEquals((int)KeyUtils.getKeyLength((Key)keyPair.getPublic()), (int)publicKeySize);
    }

    @Test
    public void ec_getKeyLength_edgeCases() {
        Assert.assertEquals((int)this.length(Base64.getDecoder().decode("DNB60oX+xWMTHlJ7SIb+iF82+Z63d+8eCIT/fMlD")), (int)256);
        Assert.assertEquals((int)this.length(Base64.getDecoder().decode("TWe6inYp+73PCZoTuqhsorCUhnI2aAlbJ0OSMCqF")), (int)256);
        Assert.assertEquals((int)this.length(Base64.getDecoder().decode("TYiB2RgMiKmZWSIhigZUhkH8jhpZfH0/6iyMH2V2")), (int)256);
        Assert.assertEquals((int)this.length(Base64.getDecoder().decode("UGg/Zd/jzBEs+B0eMcye0Pe9sKijJKwIBfXCQ3F")), (int)256);
        Assert.assertEquals((int)this.length(Base64.getDecoder().decode("a/GTpNnarc1oMRnsjo9UTCrQpK1hNGNvbSbu+t3TJXksngWwt0URBgBYZCBn6A==")), (int)384);
        Assert.assertEquals((int)this.length(Base64.getDecoder().decode("F7jFw1gM0lg+PIKMpexZe97PfUHJ+BI0CBksNVOYNp9udXMf6HmkFuPTqm3l1Q==")), (int)384);
        Assert.assertEquals((int)this.length(Base64.getDecoder().decode("bqVtyl7NwwmUkAk0GCHeQCFhiF4m7rzfYrkIp5BDPECwOMkJjgbAbBrJkqZwXA==")), (int)384);
    }

    private int length(byte[] bytes) {
        int length = bytes.length;
        int mod = length % 8;
        if (mod >= 2) {
            length += 8 - mod;
        }
        return length / 8 * 8 * 8;
    }

    @Test(dataProvider="rsaKeyLengths")
    public void rsa_getKeyLength(String algorithm, int keySize, int privateKeySize, int publicKeySize) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
        keyPairGenerator.initialize(keySize);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        Assert.assertEquals((int)KeyUtils.getKeyLength((Key)keyPair.getPrivate()), (int)privateKeySize);
        Assert.assertEquals((int)KeyUtils.getKeyLength((Key)keyPair.getPublic()), (int)publicKeySize);
    }

    @Test
    public void eddsa_25519_keyLength() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("Ed25519");
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        Assert.assertEquals((int)KeyUtils.getKeyLength((Key)keyPair.getPrivate()), (int)32);
        Assert.assertEquals((int)KeyUtils.getKeyLength((Key)keyPair.getPublic()), (int)32);
        io.fusionauth.jwt.domain.KeyPair keyPair2 = JWTUtils.generate_ed25519_EdDSAKeyPair();
        PEM pem = PEM.decode((String)keyPair2.privateKey);
        Assert.assertEquals((int)KeyUtils.getKeyLength((Key)pem.privateKey), (int)32);
        Assert.assertEquals((int)KeyUtils.getKeyLength((Key)pem.publicKey), (int)32);
    }

    @Test
    public void eddsa_448_keyLength() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("Ed448");
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        Assert.assertEquals((int)KeyUtils.getKeyLength((Key)keyPair.getPrivate()), (int)57);
        Assert.assertEquals((int)KeyUtils.getKeyLength((Key)keyPair.getPublic()), (int)57);
        io.fusionauth.jwt.domain.KeyPair keyPair2 = JWTUtils.generate_ed448_EdDSAKeyPair();
        PEM pem = PEM.decode((String)keyPair2.privateKey);
        Assert.assertEquals((int)KeyUtils.getKeyLength((Key)pem.privateKey), (int)57);
        Assert.assertEquals((int)KeyUtils.getKeyLength((Key)pem.publicKey), (int)57);
    }
}

