/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.pem;

import io.fusionauth.BaseTest;
import io.fusionauth.pem.domain.PEM;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PEMEncoderTest
extends BaseTest {
    @Test(invocationCount=250)
    public void eddsa() throws Exception {
        String privateKeyPEM = new String(Files.readAllBytes(Paths.get("src/test/resources/ed_dsa_ed25519_private_key.pem", new String[0]))).trim();
        String publicKeyPEM = new String(Files.readAllBytes(Paths.get("src/test/resources/ed_dsa_ed25519_public_key.pem", new String[0]))).trim();
        PEM pem = PEM.decode((String)privateKeyPEM);
        String extractedPublicKeyPEM = PEM.encode((Key)pem.publicKey);
        Assert.assertEquals((String)publicKeyPEM, (String)extractedPublicKeyPEM);
        String pkcs8PEM = PEM.encode((PrivateKey)pem.getPrivateKey(), (PublicKey)pem.getPublicKey());
        Assert.assertEquals((String)privateKeyPEM, (String)pkcs8PEM);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("Ed25519");
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        String encodedPublicKey = PEM.encode((Key)keyPair.getPublic());
        Assert.assertNotNull((Object)encodedPublicKey);
        Assert.assertTrue((boolean)encodedPublicKey.startsWith("-----BEGIN PUBLIC KEY-----"));
        Assert.assertTrue((boolean)encodedPublicKey.endsWith("-----END PUBLIC KEY-----"));
        String encodedPrivateKey = PEM.encode((Key)keyPair.getPrivate());
        Assert.assertNotNull((Object)encodedPrivateKey);
        Assert.assertTrue((boolean)encodedPrivateKey.startsWith("-----BEGIN PRIVATE KEY-----"));
        Assert.assertTrue((boolean)encodedPrivateKey.endsWith("-----END PRIVATE KEY-----"));
        PEM pem2 = PEM.decode((String)encodedPrivateKey);
        Assert.assertNotNull((Object)pem2.getPrivateKey());
        Assert.assertEquals((String)pem2.getPrivateKey().getFormat(), (String)"PKCS#8");
        Assert.assertEquals((String)pem2.getPrivateKey().getAlgorithm(), (String)(FipsEnabled ? "Ed25519" : "EdDSA"));
        Assert.assertNotNull((Object)pem2.getPublicKey());
        Assert.assertEquals((String)pem2.getPublicKey().getFormat(), (String)"X.509");
        Assert.assertEquals((String)pem2.getPublicKey().getAlgorithm(), (String)(FipsEnabled ? "Ed25519" : "EdDSA"));
        String encodedPrivateKey2 = PEM.encode((PrivateKey)keyPair.getPrivate(), (PublicKey)keyPair.getPublic());
        Assert.assertNotNull((Object)encodedPrivateKey2);
        PEM pem3 = PEM.decode((String)encodedPrivateKey2);
        Assert.assertEquals((String)encodedPrivateKey, (String)encodedPrivateKey2);
        Assert.assertNotNull((Object)pem3.getPrivateKey());
        Assert.assertEquals((String)pem3.getPrivateKey().getFormat(), (String)"PKCS#8");
        Assert.assertEquals((String)pem3.getPrivateKey().getAlgorithm(), (String)(FipsEnabled ? "Ed25519" : "EdDSA"));
        Assert.assertNotNull((Object)pem3.getPublicKey());
        Assert.assertEquals((String)pem3.getPublicKey().getFormat(), (String)"X.509");
        Assert.assertEquals((String)pem3.getPublicKey().getAlgorithm(), (String)(FipsEnabled ? "Ed25519" : "EdDSA"));
    }

    @Test(invocationCount=250)
    public void ec() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        keyPairGenerator.initialize(256);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        String encodedPublicKey = PEM.encode((Key)keyPair.getPublic());
        Assert.assertNotNull((Object)encodedPublicKey);
        Assert.assertTrue((boolean)encodedPublicKey.startsWith("-----BEGIN PUBLIC KEY-----"));
        Assert.assertTrue((boolean)encodedPublicKey.endsWith("-----END PUBLIC KEY-----"));
        String encodedPrivateKey = PEM.encode((Key)keyPair.getPrivate());
        Assert.assertNotNull((Object)encodedPrivateKey);
        Assert.assertTrue((boolean)encodedPrivateKey.startsWith("-----BEGIN PRIVATE KEY-----"));
        Assert.assertTrue((boolean)encodedPrivateKey.endsWith("-----END PRIVATE KEY-----"));
        PEM pem = PEM.decode((String)encodedPrivateKey);
        Assert.assertNotNull((Object)pem.getPrivateKey());
        Assert.assertNull((Object)pem.getPublicKey());
        String encodedPrivateKey2 = PEM.encode((PrivateKey)keyPair.getPrivate(), (PublicKey)keyPair.getPublic());
        Assert.assertNotNull((Object)encodedPrivateKey2);
        PEM pem2 = PEM.decode((String)encodedPrivateKey2);
        Assert.assertNotNull((Object)pem2.getPrivateKey());
        Assert.assertNotNull((Object)pem2.getPublicKey());
    }

    @Test(invocationCount=250)
    public void ec_backAndForth() throws Exception {
        String expectedPrivate = new String(Files.readAllBytes(Paths.get("src/test/resources/ec_private_prime256v1_p_256_openssl_pkcs8.pem", new String[0]))).trim();
        String expectedPublic = new String(Files.readAllBytes(Paths.get("src/test/resources/ec_public_prime256v1_p_256_openssl.pem", new String[0]))).trim();
        PEM pem = PEM.decode((String)expectedPrivate);
        Assert.assertNotNull((Object)pem);
        Assert.assertNotNull((Object)pem.getPrivateKey());
        Assert.assertNotNull((Object)pem.getPublicKey());
        ECPublicKey publicKey = (ECPublicKey)pem.getPublicKey();
        Assert.assertEquals((Object)publicKey.getW().getAffineX(), (Object)new BigInteger("7676a6ec4ee9058b59c11c8e3038e02979ccd47fca46f20fa1b130d379d9038f", 16));
        Assert.assertEquals((Object)publicKey.getW().getAffineY(), (Object)new BigInteger("8abdebcea6831f8ec07c1b4f95ceb7eb0d121cb3d23c54cfa572fba97a0de510", 16));
        String encodedPrivateKey = PEM.encode((PrivateKey)pem.getPrivateKey(), (PublicKey)pem.getPublicKey());
        Assert.assertEquals((String)encodedPrivateKey, (String)expectedPrivate);
        String encodedPublicKey = PEM.encode((Key)pem.getPublicKey());
        Assert.assertEquals((String)encodedPublicKey, (String)expectedPublic);
    }

    @Test(invocationCount=100)
    public void rsa() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        Assert.assertNotNull((Object)keyPair.getPublic());
        Assert.assertNotNull((Object)keyPair.getPrivate());
        String encodedPublicKey = PEM.encode((Key)keyPair.getPublic());
        Assert.assertNotNull((Object)encodedPublicKey);
        Assert.assertTrue((boolean)encodedPublicKey.startsWith("-----BEGIN PUBLIC KEY-----"));
        Assert.assertTrue((boolean)encodedPublicKey.endsWith("-----END PUBLIC KEY-----"));
        String encodedPrivateKey = PEM.encode((Key)keyPair.getPrivate());
        Assert.assertNotNull((Object)encodedPrivateKey);
        Assert.assertTrue((boolean)encodedPrivateKey.startsWith("-----BEGIN PRIVATE KEY-----"));
        Assert.assertTrue((boolean)encodedPrivateKey.endsWith("-----END PRIVATE KEY-----"));
        PEM pem = PEM.decode((String)encodedPrivateKey);
        Assert.assertNotNull((Object)pem.getPrivateKey());
        Assert.assertNotNull((Object)pem.getPublicKey());
    }

    @Test(invocationCount=250)
    public void rsa_backAndForth_pkcs_1() throws Exception {
        String expectedPrivate_pkcs_1 = new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_private_key_2048_pkcs_1_control.pem", new String[0]))).trim();
        String expectedPrivate_pkcs_8 = new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_private_key_2048_pkcs_8_control.pem", new String[0]))).trim();
        String expectedPublic = new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_public_key_2048_x509_control.pem", new String[0])));
        PEM pem = PEM.decode((String)expectedPrivate_pkcs_1);
        Assert.assertNotNull((Object)pem);
        Assert.assertNotNull((Object)pem.getPrivateKey());
        Assert.assertNotNull((Object)pem.getPublicKey());
        RSAPublicKey publicKey = (RSAPublicKey)pem.getPublicKey();
        String expectedModulus = "dd95ab518d18e8828dd6a238061c51d82ee81d516018f624777f2e1aad6340d4aa12f24570df770989b5ebf1bbf05005296ab0b096f75b1fa76f10e7e8bb4fe008542c1d47d0ad20eff8cb9250c01ef23cca138a96fa32bec5053d6b4dc652728792495ef90d295ff83a8d767baf5ff100ae43a36910f97e712bd722a518042b";
        Assert.assertEquals((Object)publicKey.getModulus(), (Object)new BigInteger(expectedModulus, 16));
        Assert.assertEquals((Object)publicKey.getPublicExponent(), (Object)BigInteger.valueOf(65537L));
        Assert.assertEquals((Object)publicKey.getPublicExponent(), (Object)BigInteger.valueOf(65537L));
        String encodedPrivateKey_pkcs_8 = PEM.encode((Key)pem.getPrivateKey());
        Assert.assertTrue((boolean)encodedPrivateKey_pkcs_8.startsWith("-----BEGIN PRIVATE KEY-----"));
        Assert.assertNotEquals((Object)encodedPrivateKey_pkcs_8, (Object)expectedPrivate_pkcs_1);
        Assert.assertEquals((String)encodedPrivateKey_pkcs_8, (String)expectedPrivate_pkcs_8);
        String encodedPublicKey = PEM.encode((Key)pem.getPublicKey());
        Assert.assertEquals((String)encodedPublicKey, (String)expectedPublic);
    }

    @Test(invocationCount=250)
    public void rsa_backAndForth_pkcs_8() throws Exception {
        String expectedPrivate = new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_private_key_2048_pkcs_8_control.pem", new String[0]))).trim();
        String expectedPublic = new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_public_key_2048_x509_control.pem", new String[0]))).trim();
        PEM pem = PEM.decode((String)expectedPrivate);
        Assert.assertNotNull((Object)pem);
        Assert.assertNotNull((Object)pem.getPrivateKey());
        Assert.assertNotNull((Object)pem.getPublicKey());
        RSAPublicKey publicKey = (RSAPublicKey)pem.getPublicKey();
        String expectedModulus = "dd95ab518d18e8828dd6a238061c51d82ee81d516018f624777f2e1aad6340d4aa12f24570df770989b5ebf1bbf05005296ab0b096f75b1fa76f10e7e8bb4fe008542c1d47d0ad20eff8cb9250c01ef23cca138a96fa32bec5053d6b4dc652728792495ef90d295ff83a8d767baf5ff100ae43a36910f97e712bd722a518042b";
        Assert.assertEquals((Object)publicKey.getModulus(), (Object)new BigInteger(expectedModulus, 16));
        Assert.assertEquals((Object)publicKey.getPublicExponent(), (Object)BigInteger.valueOf(65537L));
        Assert.assertEquals((Object)publicKey.getPublicExponent(), (Object)BigInteger.valueOf(65537L));
        String encodedPrivateKey_pkcs_8 = PEM.encode((Key)pem.getPrivateKey());
        Assert.assertTrue((boolean)encodedPrivateKey_pkcs_8.startsWith("-----BEGIN PRIVATE KEY-----"));
        Assert.assertEquals((String)encodedPrivateKey_pkcs_8, (String)expectedPrivate);
        String encodedPublicKey = PEM.encode((Key)pem.getPublicKey());
        Assert.assertEquals((String)encodedPublicKey, (String)expectedPublic);
    }
}

