/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.pem;

import io.fusionauth.pem.domain.PEM;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PEMDecoderTest {
    @Test
    public void inputs() throws Exception {
        Assert.assertNotNull((Object)PEM.decode((Path)Paths.get("src/test/resources/ec_public_key_p_256.pem", new String[0])));
        Assert.assertNotNull((Object)PEM.decode((byte[])Files.readAllBytes(Paths.get("src/test/resources/ec_public_key_p_256.pem", new String[0]))));
        Assert.assertNotNull((Object)PEM.decode((String)new String(Files.readAllBytes(Paths.get("src/test/resources/ec_public_key_p_256.pem", new String[0])))));
    }

    @Test
    public void private_ec() throws Exception {
        List<String> filesIncludingPublicKey = Arrays.asList("ec_private_prime256v1_p_256_openssl.pem", "ec_private_secp384r1_p_384_openssl.pem", "ec_private_secp521r1_p_512_openssl.pem");
        for (String f : filesIncludingPublicKey) {
            String message = "For file [" + f + "]";
            String encodedPEM = new String(Files.readAllBytes(Paths.get("src/test/resources/" + f, new String[0])));
            Assert.assertTrue((boolean)encodedPEM.contains("-----BEGIN EC PRIVATE KEY-----"), (String)message);
            PEM pem = PEM.decode((String)encodedPEM);
            Assert.assertNotNull((Object)pem.privateKey, (String)message);
            Assert.assertEquals((String)pem.privateKey.getFormat(), (String)"PKCS#8", (String)message);
            Assert.assertNotNull((Object)pem.publicKey, (String)message);
            Assert.assertEquals((String)pem.publicKey.getFormat(), (String)"X.509", (String)message);
        }
    }

    @Test
    public void private_pkcs_8() throws Exception {
        List<String> filesIncludingPublicKey = Arrays.asList("ec_private_key_control.pem", "ec_private_prime256v1_p_256_openssl_pkcs8.pem", "ec_private_secp384r1_p_384_openssl_pkcs8.pem", "ec_private_secp521r1_p_512_openssl_pkcs8.pem", "rsa_private_key_2048_pkcs_8_control.pem", "rsa_private_key_3072.pem", "rsa_pss_private_key_2048.pem", "rsa_pss_private_key_3072.pem", "rsa_pss_private_key_4096.pem");
        for (String f : filesIncludingPublicKey) {
            String message = "For file [" + f + "]";
            String encodedPEM = new String(Files.readAllBytes(Paths.get("src/test/resources/" + f, new String[0])));
            Assert.assertTrue((boolean)encodedPEM.contains("-----BEGIN PRIVATE KEY-----"), (String)message);
            PEM pem = PEM.decode((String)encodedPEM);
            Assert.assertNotNull((Object)pem.privateKey, (String)message);
            Assert.assertEquals((String)pem.privateKey.getFormat(), (String)"PKCS#8", (String)message);
            Assert.assertNotNull((Object)pem.publicKey, (String)message);
            Assert.assertEquals((String)pem.publicKey.getFormat(), (String)"X.509", (String)message);
        }
        List<String> filesDoNotIncludePublicKey = Arrays.asList("ec_private_key_p_256.pem", "ec_private_key_p_384.pem", "ec_private_key_p_521.pem");
        for (String f : filesDoNotIncludePublicKey) {
            String message = "For file [" + f + "]";
            String encodedPEM = new String(Files.readAllBytes(Paths.get("src/test/resources/" + f, new String[0])));
            Assert.assertTrue((boolean)encodedPEM.contains("-----BEGIN PRIVATE KEY-----"), (String)message);
            PEM pem = PEM.decode((String)encodedPEM);
            Assert.assertNotNull((Object)pem.privateKey, (String)message);
            Assert.assertNull((Object)pem.publicKey, (String)message);
        }
    }

    @Test
    public void private_rsa_pkcs_1() throws Exception {
        List<String> files = Arrays.asList("rsa_private_key_2048.pem", "rsa_private_key_2048_pkcs_1.pem", "rsa_private_key_4096_pkcs_1.pem", "rsa_private_key_2048_pkcs_1_control.pem", "rsa_private_key_2048_with_meta.pem", "rsa_private_key_4096.pem", "rsa_private_key_2048_RS256_control.pem");
        for (String f : files) {
            String message = "For file [" + f + "]";
            String encodedPEM = new String(Files.readAllBytes(Paths.get("src/test/resources/" + f, new String[0])));
            Assert.assertTrue((boolean)encodedPEM.contains("-----BEGIN RSA PRIVATE KEY-----"), (String)message);
            PEM pem = PEM.decode((String)encodedPEM);
            Assert.assertNotNull((Object)pem.privateKey, (String)message);
            Assert.assertEquals((String)pem.privateKey.getFormat(), (String)"PKCS#8", (String)message);
            Assert.assertNotNull((Object)pem.publicKey, (String)message);
            Assert.assertEquals((String)pem.publicKey.getFormat(), (String)"X.509", (String)message);
        }
    }

    @Test
    public void certificates() throws Exception {
        List<String> files = Arrays.asList("rsa_certificate_1024.pem", "rsa_certificate_2048.pem");
        for (String f : files) {
            String message = "For file [" + f + "]";
            String encodedPEM = new String(Files.readAllBytes(Paths.get("src/test/resources/" + f, new String[0])));
            Assert.assertTrue((boolean)encodedPEM.contains("-----BEGIN CERTIFICATE-----"), (String)message);
            PEM pem = PEM.decode((String)encodedPEM);
            Assert.assertNull((Object)pem.privateKey, (String)message);
            Assert.assertNotNull((Object)pem.certificate, (String)message);
            Assert.assertNotNull((Object)pem.publicKey, (String)message);
            Assert.assertEquals((String)pem.publicKey.getFormat(), (String)"X.509", (String)message);
            Assert.assertEquals((String)pem.certificate.getType(), (String)"X.509", (String)message);
        }
    }

    @Test
    public void public_x509() throws Exception {
        List<String> files = Arrays.asList("ec_public_key_p_256.pem", "ec_public_key_p_256_control.pem", "rsa_public_key_2048_x509.pem", "rsa_public_key_4096_x509.pem", "rsa_public_key_2048_x509_control.pem", "rsa_public_key_2048_RS256_control.pem");
        for (String f : files) {
            String message = "For file [" + f + "]";
            String encodedPEM = new String(Files.readAllBytes(Paths.get("src/test/resources/" + f, new String[0])));
            Assert.assertTrue((boolean)encodedPEM.contains("-----BEGIN PUBLIC KEY-----"), (String)message);
            PEM pem = PEM.decode((String)encodedPEM);
            Assert.assertNull((Object)pem.privateKey, (String)message);
            Assert.assertNotNull((Object)pem.publicKey, (String)message);
            Assert.assertEquals((String)pem.publicKey.getFormat(), (String)"X.509", (String)message);
        }
    }
}

