/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.oauth2;

import io.fusionauth.BaseTest;
import io.fusionauth.http.ExpectedResponse;
import io.fusionauth.http.HttpServerBuilder;
import io.fusionauth.oauth2.ServerMetaDataHelper;
import io.fusionauth.oauth2.domain.AuthorizationServerMetaData;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Paths;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ServerMetaDataTest
extends BaseTest {
    @Test
    public void test() throws Exception {
        this.startHttpServer((HttpServerBuilder server) -> server.listenOn(4242).handleURI("/.well-known/oauth-authorization-server").andReturn((ExpectedResponse)((ExpectedResponse)((ExpectedResponse)new ExpectedResponse().with(response -> {
            response.responseFile = Paths.get("src/test/resources/oauth2/example_server_metadata.json", new String[0]);
        })).with(response -> {
            response.contentType = "application/json";
        })).with(response -> {
            response.status = 200;
        })));
        AuthorizationServerMetaData metaData1 = ServerMetaDataHelper.retrieveFromIssuer((String)"http://localhost:4242");
        AuthorizationServerMetaData metaData2 = ServerMetaDataHelper.retrieveFromWellKnownConfiguration((String)"http://localhost:4242/.well-known/oauth-authorization-server");
        AuthorizationServerMetaData metaData3 = ServerMetaDataHelper.retrieveFromWellKnownConfiguration((HttpURLConnection)((HttpURLConnection)new URL("http://localhost:4242/.well-known/oauth-authorization-server").openConnection()));
        Assert.assertEquals((Object)metaData1, (Object)metaData2);
        Assert.assertEquals((Object)metaData2, (Object)metaData3);
    }
}

