/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.rsa;

import io.fusionauth.jwt.BaseJWTTest;
import io.fusionauth.jwt.InvalidKeyLengthException;
import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.jwt.rsa.RSAVerifier;
import io.fusionauth.pem.domain.PEM;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RSAVerifierTest
extends BaseJWTTest {
    @Test
    public void test_public_pem_parsing() {
        Arrays.asList("rsa_certificate_2048.pem", "rsa_public_key_2047.pem", "rsa_public_key_2048.pem", "rsa_public_key_2048_with_meta.pem", "rsa_public_key_3072.pem", "rsa_public_key_4096.pem", "rsa_pss_public_key_2048.pem", "rsa_pss_public_key_3072.pem", "rsa_pss_public_key_4096.pem").forEach(fileName -> {
            this.assertRSAVerifier((Verifier)RSAVerifier.newVerifier((Path)this.getPath((String)fileName)));
            this.assertRSAVerifier((Verifier)RSAVerifier.newVerifier((String)this.readFile((String)fileName)));
            this.assertRSAVerifier((Verifier)RSAVerifier.newVerifier((byte[])this.readFile((String)fileName).getBytes(StandardCharsets.UTF_8)));
            this.assertRSAVerifier((Verifier)RSAVerifier.newVerifier((PublicKey)((RSAPublicKey)PEM.decode((String)this.readFile((String)fileName)).getPublicKey())));
        });
        Arrays.asList("rsa_private_key_2048.pem", "rsa_private_key_2048_with_meta.pem", "rsa_private_key_3072.pem", "rsa_private_key_4096.pem", "rsa_pss_private_key_2048.pem", "rsa_pss_private_key_3072.pem", "rsa_pss_private_key_4096.pem").forEach(fileName -> {
            this.assertRSAVerifier((Verifier)RSAVerifier.newVerifier((Path)this.getPath((String)fileName)));
            this.assertRSAVerifier((Verifier)RSAVerifier.newVerifier((String)this.readFile((String)fileName)));
            this.assertRSAVerifier((Verifier)RSAVerifier.newVerifier((byte[])this.readFile((String)fileName).getBytes(StandardCharsets.UTF_8)));
            this.assertRSAVerifier((Verifier)RSAVerifier.newVerifier((PublicKey)((RSAPublicKey)PEM.decode((String)this.readFile((String)fileName)).getPublicKey())));
        });
    }

    @Test
    public void test_rsa_1024_pem() {
        try {
            RSAVerifier.newVerifier((String)new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_public_key_1024.pem", new String[0]))));
            Assert.fail((String)"Expected [InvalidKeyLengthException] exception");
        }
        catch (InvalidKeyLengthException invalidKeyLengthException) {
        }
        catch (Exception e) {
            Assert.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    private void assertRSAVerifier(Verifier verifier) {
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.ES256));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.ES384));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.ES512));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.HS256));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.HS384));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.HS512));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.PS256));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.PS384));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.PS512));
        Assert.assertTrue((boolean)verifier.canVerify(Algorithm.RS256));
        Assert.assertTrue((boolean)verifier.canVerify(Algorithm.RS384));
        Assert.assertTrue((boolean)verifier.canVerify(Algorithm.RS512));
    }
}

