/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.rsa;

import io.fusionauth.jwt.BaseJWTTest;
import io.fusionauth.jwt.InvalidKeyLengthException;
import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.jwt.domain.JWT;
import io.fusionauth.jwt.rsa.RSAPSSVerifier;
import io.fusionauth.pem.domain.PEM;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RSAPSSVerifierTest
extends BaseJWTTest {
    @Test
    public void test_public_pem_parsing() {
        Arrays.asList("rsa_certificate_2048.pem", "rsa_public_key_2048.pem", "rsa_public_key_2048_with_meta.pem", "rsa_public_key_3072.pem", "rsa_public_key_4096.pem", "rsa_pss_public_key_2048.pem", "rsa_pss_public_key_3072.pem", "rsa_pss_public_key_4096.pem").forEach(fileName -> {
            this.assertRSAPSAVerifier((Verifier)RSAPSSVerifier.newVerifier((Path)this.getPath((String)fileName)));
            this.assertRSAPSAVerifier((Verifier)RSAPSSVerifier.newVerifier((String)this.readFile((String)fileName)));
            this.assertRSAPSAVerifier((Verifier)RSAPSSVerifier.newVerifier((byte[])this.readFile((String)fileName).getBytes(StandardCharsets.UTF_8)));
            this.assertRSAPSAVerifier((Verifier)RSAPSSVerifier.newVerifier((PublicKey)((RSAPublicKey)PEM.decode((String)this.readFile((String)fileName)).getPublicKey())));
        });
        Arrays.asList("rsa_private_key_2048.pem", "rsa_private_key_2048_with_meta.pem", "rsa_private_key_3072.pem", "rsa_private_key_4096.pem", "rsa_pss_private_key_2048.pem", "rsa_pss_private_key_3072.pem", "rsa_pss_private_key_4096.pem").forEach(fileName -> {
            this.assertRSAPSAVerifier((Verifier)RSAPSSVerifier.newVerifier((Path)this.getPath((String)fileName)));
            this.assertRSAPSAVerifier((Verifier)RSAPSSVerifier.newVerifier((String)this.readFile((String)fileName)));
            this.assertRSAPSAVerifier((Verifier)RSAPSSVerifier.newVerifier((byte[])this.readFile((String)fileName).getBytes(StandardCharsets.UTF_8)));
            this.assertRSAPSAVerifier((Verifier)RSAPSSVerifier.newVerifier((PublicKey)((RSAPublicKey)PEM.decode((String)this.readFile((String)fileName)).getPublicKey())));
        });
    }

    @Test
    public void test_rsa_1024_pem() {
        try {
            RSAPSSVerifier.newVerifier((String)new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_public_key_1024.pem", new String[0]))));
            Assert.fail((String)"Expected [InvalidKeyLengthException] exception");
        }
        catch (InvalidKeyLengthException invalidKeyLengthException) {
        }
        catch (Exception e) {
            Assert.fail((String)"Unexpected exception", (Throwable)e);
        }
    }

    @Test
    public void control() {
        String encodedJWT = "eyJhbGciOiJQUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiYWRtaW4iOnRydWUsImlhdCI6MTUxNjIzOTAyMn0.hZnl5amPk_I3tb4O-Otci_5XZdVWhPlFyVRvcqSwnDo_srcysDvhhKOD01DigPK1lJvTSTolyUgKGtpLqMfRDXQlekRsF4XhAjYZTmcynf-C-6wO5EI4wYewLNKFGGJzHAknMgotJFjDi_NCVSjHsW3a10nTao1lB82FRS305T226Q0VqNVJVWhE4G0JQvi2TssRtCxYTqzXVt22iDKkXeZJARZ1paXHGV5Kd1CljcZtkNZYIGcwnj65gvuCwohbkIxAnhZMJXCLaVvHqv9l-AAUV7esZvkQR1IpwBAiDQJh4qxPjFGylyXrHMqh5NlT_pWL2ZoULWTg_TJjMO9TuQ";
        String publicKeyPEM = "-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAnzyis1ZjfNB0bBgKFMSv\nvkTtwlvBsaJq7S5wA+kzeVOVpVWwkWdVha4s38XM/pa/yr47av7+z3VTmvDRyAHc\naT92whREFpLv9cj5lTeJSibyr/Mrm/YtjCZVWgaOYIhwrXwKLqPr/11inWsAkfIy\ntvHWTxZYEcXLgAXFuUuaS3uF9gEiNQwzGTU1v0FqkqTBr4B8nW3HCN47XUu0t8Y0\ne+lf4s4OxQawWD79J9/5d3Ry0vbV3Am1FtGJiJvOwRsIfVChDpYStTcHTCMqtvWb\nV6L11BWkpzGXSW4Hv43qa+GSYOD2QU68Mb59oSk2OB+BtOLpJofmbGEGgvmwyCI9\nMwIDAQAB\n-----END PUBLIC KEY-----";
        RSAPSSVerifier verifier = RSAPSSVerifier.newVerifier((String)publicKeyPEM);
        JWT jwt = JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertNotNull((Object)jwt);
        Assert.assertEquals((String)jwt.subject, (String)"1234567890");
        Assert.assertEquals((String)jwt.getString("name"), (String)"John Doe");
        Assert.assertEquals((Boolean)jwt.getBoolean("admin"), (Boolean)Boolean.TRUE);
    }

    private void assertRSAPSAVerifier(Verifier verifier) {
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.ES256));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.ES384));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.ES512));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.HS256));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.HS384));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.HS512));
        Assert.assertTrue((boolean)verifier.canVerify(Algorithm.PS256));
        Assert.assertTrue((boolean)verifier.canVerify(Algorithm.PS384));
        Assert.assertTrue((boolean)verifier.canVerify(Algorithm.PS512));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.RS256));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.RS384));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.RS512));
    }
}

