/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.ec;

import io.fusionauth.jwt.BaseJWTTest;
import io.fusionauth.jwt.MissingPublicKeyException;
import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.jwt.ec.ECVerifier;
import io.fusionauth.pem.domain.PEM;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.InvalidParameterException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ECVerifierTest
extends BaseJWTTest {
    @Test
    public void test_public_pem_parsing() {
        Arrays.asList("ec_public_key_p_256.pem", "ec_public_key_p_384.pem", "ec_public_key_p_521.pem").forEach(fileName -> {
            this.assertECVerifier((Verifier)ECVerifier.newVerifier((Path)this.getPath((String)fileName)));
            this.assertECVerifier((Verifier)ECVerifier.newVerifier((String)this.readFile((String)fileName)));
            this.assertECVerifier((Verifier)ECVerifier.newVerifier((byte[])this.readFile((String)fileName).getBytes(StandardCharsets.UTF_8)));
            this.assertECVerifier((Verifier)ECVerifier.newVerifier((PublicKey)((ECPublicKey)PEM.decode((String)this.readFile((String)fileName)).getPublicKey())));
        });
        Arrays.asList("ec_private_key_p_256.pem", "ec_private_key_p_384.pem", "ec_private_key_p_521.pem").forEach(this::assertFailed);
        Arrays.asList("ec_private_prime256v1_p_256_openssl.pem", "ec_private_prime256v1_p_256_openssl_pkcs8.pem", "ec_private_secp384r1_p_384_openssl.pem", "ec_private_secp384r1_p_384_openssl_pkcs8.pem", "ec_private_secp521r1_p_512_openssl.pem", "ec_private_secp521r1_p_512_openssl_pkcs8.pem").forEach(fileName -> {
            this.assertECVerifier((Verifier)ECVerifier.newVerifier((Path)this.getPath((String)fileName)));
            this.assertECVerifier((Verifier)ECVerifier.newVerifier((String)this.readFile((String)fileName)));
            this.assertECVerifier((Verifier)ECVerifier.newVerifier((byte[])this.readFile((String)fileName).getBytes(StandardCharsets.UTF_8)));
            this.assertECVerifier((Verifier)ECVerifier.newVerifier((PublicKey)((ECPublicKey)PEM.decode((String)this.readFile((String)fileName)).getPublicKey())));
        });
    }

    private void assertECVerifier(Verifier verifier) {
        Assert.assertTrue((boolean)verifier.canVerify(Algorithm.ES256));
        Assert.assertTrue((boolean)verifier.canVerify(Algorithm.ES384));
        Assert.assertTrue((boolean)verifier.canVerify(Algorithm.ES512));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.HS256));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.HS384));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.HS512));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.PS256));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.PS384));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.PS512));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.RS256));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.RS384));
        Assert.assertFalse((boolean)verifier.canVerify(Algorithm.RS512));
    }

    private void assertFailed(String fileName) {
        try {
            ECVerifier.newVerifier((String)this.readFile(fileName));
            Assert.fail((String)"Expected [InvalidParameterException] exception");
        }
        catch (InvalidParameterException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Unexpected Public Key Format", (String)("[" + fileName + "]"));
        }
        catch (MissingPublicKeyException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"The provided PEM encoded string did not contain a public key.");
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception when parsing file [" + fileName + "]"), (Throwable)e);
        }
    }
}

