/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt;

import io.fusionauth.BaseTest;
import io.fusionauth.jwt.OpenIDConnect;
import io.fusionauth.jwt.domain.Algorithm;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class OpenIdConnectTest
extends BaseTest {
    @Test
    public void test_at_hash() {
        Assert.assertEquals((String)OpenIDConnect.at_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.HS256), (String)"wfgvmE9VxjAudsl9lc6TqA");
        Assert.assertEquals((String)OpenIDConnect.at_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.HS384), (String)"phZaPQJosyg-qi-OIYyQ3xJB9wsHYEEz");
        Assert.assertEquals((String)OpenIDConnect.at_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.HS512), (String)"8xltSlOGYrWy8W9yNvRlEth1i_bXW-JROWPLvCv5zog");
        Assert.assertEquals((String)OpenIDConnect.at_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.ES256), (String)"wfgvmE9VxjAudsl9lc6TqA");
        Assert.assertEquals((String)OpenIDConnect.at_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.ES384), (String)"phZaPQJosyg-qi-OIYyQ3xJB9wsHYEEz");
        Assert.assertEquals((String)OpenIDConnect.at_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.ES512), (String)"8xltSlOGYrWy8W9yNvRlEth1i_bXW-JROWPLvCv5zog");
        Assert.assertEquals((String)OpenIDConnect.at_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.RS256), (String)"wfgvmE9VxjAudsl9lc6TqA");
        Assert.assertEquals((String)OpenIDConnect.at_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.RS384), (String)"phZaPQJosyg-qi-OIYyQ3xJB9wsHYEEz");
        Assert.assertEquals((String)OpenIDConnect.at_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.RS512), (String)"8xltSlOGYrWy8W9yNvRlEth1i_bXW-JROWPLvCv5zog");
        Assert.assertEquals((String)OpenIDConnect.at_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.Ed25519), (String)"8xltSlOGYrWy8W9yNvRlEth1i_bXW-JROWPLvCv5zog");
        this.requiresShake256(() -> Assert.assertEquals((String)OpenIDConnect.at_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.Ed448), (String)"ACuRpk9jl5IEa3yqpBCNNOCpBEI7qjud6mc80cs6vWX2fcqpsk8RozYBKTUuSS6SqJhw302xFZeM"));
        Assert.assertEquals((String)OpenIDConnect.at_hash((String)"1940a308-d492-3660-a9f8-46723cc582e9", (Algorithm)Algorithm.RS256), (String)"JrZY9MtYVEIIJUx-DDBmww");
        Assert.assertEquals((String)OpenIDConnect.at_hash((String)"jHkWEdUXMU1BwAsC4vtUsZwnNvTIxEl0z9K3vx5KF0Y", (Algorithm)Algorithm.RS256), (String)"77QmUPtjPfzWtF2AnpK9RQ");
        this.requiresShake256(() -> Assert.assertEquals((String)OpenIDConnect.at_hash((String)"YmJiZTAwYmYtMzgyOC00NzhkLTkyOTItNjJjNDM3MGYzOWIy9sFhvH8K_x8UIHj1osisS57f5DduL", (Algorithm)Algorithm.Ed448), (String)"sB_U72jyb0WgtX8TsVoqJnm6CD295W9gfSDRxkilB3LAL7REi9JYutRW_s1yE4lD8cOfMZf83gi4"));
    }

    private void requiresShake256(Runnable runnable) {
        block3: {
            try {
                runnable.run();
                if (!FipsEnabled) {
                    AssertJUnit.fail((String)"Expected this to fail unless FIPS was enabled.");
                }
            }
            catch (Exception e) {
                if (!FipsEnabled) break block3;
                throw e;
            }
        }
    }

    @Test
    public void test_c_hash() {
        Assert.assertEquals((String)OpenIDConnect.c_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.HS256), (String)"wfgvmE9VxjAudsl9lc6TqA");
        Assert.assertEquals((String)OpenIDConnect.c_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.HS384), (String)"phZaPQJosyg-qi-OIYyQ3xJB9wsHYEEz");
        Assert.assertEquals((String)OpenIDConnect.c_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.HS512), (String)"8xltSlOGYrWy8W9yNvRlEth1i_bXW-JROWPLvCv5zog");
        Assert.assertEquals((String)OpenIDConnect.c_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.ES256), (String)"wfgvmE9VxjAudsl9lc6TqA");
        Assert.assertEquals((String)OpenIDConnect.c_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.ES384), (String)"phZaPQJosyg-qi-OIYyQ3xJB9wsHYEEz");
        Assert.assertEquals((String)OpenIDConnect.c_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.ES512), (String)"8xltSlOGYrWy8W9yNvRlEth1i_bXW-JROWPLvCv5zog");
        Assert.assertEquals((String)OpenIDConnect.c_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.RS256), (String)"wfgvmE9VxjAudsl9lc6TqA");
        Assert.assertEquals((String)OpenIDConnect.c_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.RS384), (String)"phZaPQJosyg-qi-OIYyQ3xJB9wsHYEEz");
        Assert.assertEquals((String)OpenIDConnect.c_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.RS512), (String)"8xltSlOGYrWy8W9yNvRlEth1i_bXW-JROWPLvCv5zog");
        Assert.assertEquals((String)OpenIDConnect.c_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.Ed25519), (String)"8xltSlOGYrWy8W9yNvRlEth1i_bXW-JROWPLvCv5zog");
        this.requiresShake256(() -> Assert.assertEquals((String)OpenIDConnect.c_hash((String)"dNZX1hEZ9wBCzNL40Upu646bdzQA", (Algorithm)Algorithm.Ed448), (String)"ACuRpk9jl5IEa3yqpBCNNOCpBEI7qjud6mc80cs6vWX2fcqpsk8RozYBKTUuSS6SqJhw302xFZeM"));
        Assert.assertEquals((String)OpenIDConnect.c_hash((String)"16fd899f-5f0c-3114-875e-2547b629cd05", (Algorithm)Algorithm.HS256), (String)"S5UOXRNNyYsI6Z0G3xxdpw");
        Assert.assertEquals((String)OpenIDConnect.c_hash((String)"Qcb0Orv1zh30vL1MPRsbm-diHiMwcLyZvn1arpZv-Jxf_11jnpEX3Tgfvk", (Algorithm)Algorithm.HS256), (String)"LDktKdoQak3Pk0cnXxCltA");
    }

    @Test
    public void validation() {
        try {
            OpenIDConnect.at_hash((String)"foo", (Algorithm)Algorithm.none);
            AssertJUnit.fail((String)"expected exception when passing an invalid Algorithm");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            OpenIDConnect.c_hash((String)"foo", (Algorithm)Algorithm.none);
            AssertJUnit.fail((String)"expected exception when passing an invalid Algorithm");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

