/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt;

import io.fusionauth.BaseTest;
import io.fusionauth.jwt.json.Mapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.testng.Assert;

public abstract class BaseJWTTest
extends BaseTest {
    private static Map<String, Object> deepSort(Map<String, Object> response) {
        TreeMap<String, Object> sorted = new TreeMap<String, Object>();
        response.forEach((key, value) -> {
            if (value instanceof Map) {
                sorted.put((String)key, BaseJWTTest.deepSort((Map)value));
            } else if (value instanceof List) {
                sorted.put((String)key, BaseJWTTest.deepSort((List)value));
            } else {
                sorted.put((String)key, value);
            }
        });
        return sorted;
    }

    private static List<Object> deepSort(List<Object> list) {
        ArrayList<Object> sorted = new ArrayList<Object>();
        list.forEach(value -> {
            if (value instanceof Map) {
                sorted.add(BaseJWTTest.deepSort((Map)value));
            } else if (value instanceof List) {
                sorted.add(BaseJWTTest.deepSort((List)value));
            } else {
                sorted.add(value);
            }
        });
        sorted.sort(Comparator.comparing(value -> new String(Mapper.prettyPrint((Object)value))));
        return sorted;
    }

    protected void assertJSONEquals(Object object, String jsonFile) throws IOException {
        Map<String, Object> actual = (Map<String, Object>)Mapper.deserialize((byte[])Mapper.serialize((Object)object), Map.class);
        Map<String, Object> expected = (Map<String, Object>)Mapper.deserialize((byte[])Files.readAllBytes(Paths.get(jsonFile, new String[0])), Map.class);
        if (!(actual = BaseJWTTest.deepSort(actual)).equals(expected = BaseJWTTest.deepSort(expected))) {
            String actualString = new String(Mapper.prettyPrint(actual));
            String expectedString = new String(Mapper.prettyPrint(expected));
            throw new AssertionError((Object)("The actual JSON doesn't match the expected JSON output. expected [" + expectedString + "] but found [" + actualString + "]"));
        }
    }

    protected void expectException(Class<? extends Exception> expected, ThrowingRunnable runnable) {
        block2: {
            try {
                runnable.run();
                Assert.fail((String)("Expected [" + expected.getCanonicalName() + "] to be thrown. No Exception was thrown."));
            }
            catch (Exception e) {
                if (e.getClass().isAssignableFrom(expected)) break block2;
                Assert.fail((String)("Expected [" + expected.getCanonicalName() + "] to be thrown. Caught this instead [" + e.getClass().getCanonicalName() + "]"));
            }
        }
    }

    protected Path getPath(String fileName) {
        return Paths.get("src/test/resources/" + fileName, new String[0]);
    }

    protected String readFile(String fileName) {
        try {
            return new String(Files.readAllBytes(Paths.get("src/test/resources/" + fileName, new String[0])));
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected file I/O exception.", (Throwable)e);
            return null;
        }
    }

    protected static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

