/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwks;

import io.fusionauth.jwks.JSONWebKeyBuilderException;
import io.fusionauth.jwks.domain.JSONWebKey;
import io.fusionauth.jwt.BaseJWTTest;
import io.fusionauth.jwt.JWTUtils;
import io.fusionauth.jwt.Signer;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.jwt.domain.Header;
import io.fusionauth.jwt.domain.JWT;
import io.fusionauth.jwt.rsa.RSAPSSSigner;
import io.fusionauth.jwt.rsa.RSAPSSVerifier;
import io.fusionauth.jwt.rsa.RSASigner;
import io.fusionauth.pem.domain.PEM;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.EdECPrivateKey;
import java.security.interfaces.EdECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JSONWebKeyBuilderTest
extends BaseJWTTest {
    @Test
    public void add_named_properties() {
        Arrays.asList("alg", "crv", "d", "dp", "dq", "e", "kid", "kty", "n", "p", "q", "qi", "use", "x", "x5c", "x5t", "x5t_256", "y").forEach(key -> this.expectException(JSONWebKeyBuilderException.class, () -> new JSONWebKey().add(key, (Object)"Nunya, Business")));
    }

    @Test
    public void ec_private() throws Exception {
        ECPrivateKey key = (ECPrivateKey)PEM.decode((Path)Paths.get("src/test/resources/ec_private_prime256v1_p_256_openssl_pkcs8.pem", new String[0])).getPrivateKey();
        this.assertJSONEquals(JSONWebKey.build((PrivateKey)key), "src/test/resources/jwk/ec_private_prime256v1_p_256_openssl_pkcs8.json");
    }

    @Test
    public void ec_public() throws Exception {
        ECPublicKey ecPublic_p256 = (ECPublicKey)PEM.decode((Path)Paths.get("src/test/resources/ec_public_key_p_256.pem", new String[0])).getPublicKey();
        this.assertJSONEquals(JSONWebKey.build((PublicKey)ecPublic_p256), "src/test/resources/jwk/ec_public_key_p_256.json");
        Certificate ec_certificate_p256 = PEM.decode((Path)Paths.get("src/test/resources/ec_certificate_p_256.pem", new String[0])).getCertificate();
        this.assertJSONEquals(JSONWebKey.build((Certificate)ec_certificate_p256), "src/test/resources/jwk/ec_certificate_p_256.json");
        ECPublicKey ecPublic_p384 = (ECPublicKey)PEM.decode((Path)Paths.get("src/test/resources/ec_public_key_p_384.pem", new String[0])).getPublicKey();
        this.assertJSONEquals(JSONWebKey.build((PublicKey)ecPublic_p384), "src/test/resources/jwk/ec_public_key_p_384.json");
        Certificate ec_certificate_p384 = PEM.decode((Path)Paths.get("src/test/resources/ec_certificate_p_384.pem", new String[0])).getCertificate();
        this.assertJSONEquals(JSONWebKey.build((Certificate)ec_certificate_p384), "src/test/resources/jwk/ec_certificate_p_384.json");
        ECPublicKey ecPublic_p512 = (ECPublicKey)PEM.decode((Path)Paths.get("src/test/resources/ec_public_key_p_521.pem", new String[0])).getPublicKey();
        this.assertJSONEquals(JSONWebKey.build((PublicKey)ecPublic_p512), "src/test/resources/jwk/ec_public_key_p_521.json");
        Certificate ec_certificate_p512 = PEM.decode((Path)Paths.get("src/test/resources/ec_certificate_p_521.pem", new String[0])).getCertificate();
        this.assertJSONEquals(JSONWebKey.build((Certificate)ec_certificate_p512), "src/test/resources/jwk/ec_certificate_p_521.json");
        ECPublicKey ec521key = (ECPublicKey)PEM.decode((Path)Paths.get("src/test/resources/ec_public_p_521_reference.pem", new String[0])).getPublicKey();
        this.assertJSONEquals(JSONWebKey.build((PublicKey)ec521key), "src/test/resources/jwk/ec_public_p_521_reference.json");
    }

    @Test
    public void extra_properties() throws Exception {
        ECPublicKey ecPublic_p256 = (ECPublicKey)PEM.decode((Path)Paths.get("src/test/resources/ec_public_key_p_256.pem", new String[0])).getPublicKey();
        this.assertJSONEquals(JSONWebKey.build((PublicKey)ecPublic_p256).add("more", (Object)"cowbell").add("boom", (Object)"goes the dynamite"), "src/test/resources/jwk/extra_properties.json");
    }

    @Test
    public void rsa_private() throws Exception {
        RSAPrivateKey privateKey = (RSAPrivateKey)PEM.decode((Path)Paths.get("src/test/resources/rsa_private_key_jwk_control.pem", new String[0])).getPrivateKey();
        this.assertJSONEquals(JSONWebKey.build((PrivateKey)privateKey), "src/test/resources/jwk/rsa_private_key_jwk_control.json");
    }

    @Test
    public void rsa_pss_private() throws Exception {
        RSAPrivateKey privateKey = (RSAPrivateKey)PEM.decode((Path)Paths.get("src/test/resources/rsa_pss_private_key_2048.pem", new String[0])).getPrivateKey();
        this.assertJSONEquals(JSONWebKey.build((PrivateKey)privateKey), "src/test/resources/jwk/rsa_pss_private_key_2048.json");
        RSAPSSSigner signer = RSAPSSSigner.newSHA256Signer((PrivateKey)privateKey);
        String message = "hello world!";
        byte[] messageBytes = message.getBytes(StandardCharsets.UTF_8);
        byte[] signature = signer.sign(message);
        RSAPublicKey publicKey = (RSAPublicKey)PEM.decode((Path)Paths.get("src/test/resources/rsa_pss_public_key_2048.pem", new String[0])).getPublicKey();
        RSAPSSVerifier verifier = RSAPSSVerifier.newVerifier((PublicKey)publicKey);
        verifier.canVerify(Algorithm.PS256);
        verifier.canVerify(Algorithm.PS384);
        verifier.canVerify(Algorithm.PS512);
        verifier.verify(Algorithm.PS256, messageBytes, signature);
    }

    @Test
    public void rsa_pss_public() throws Exception {
        RSAPublicKey publicKey = (RSAPublicKey)PEM.decode((Path)Paths.get("src/test/resources/rsa_pss_public_key_2048.pem", new String[0])).getPublicKey();
        this.assertJSONEquals(JSONWebKey.build((PublicKey)publicKey), "src/test/resources/jwk/rsa_pss_public_key_2048.json");
        Certificate certificate = PEM.decode((Path)Paths.get((String)"src/test/resources/rsa_pss_public_key_2048_certificate.pem", (String[])new String[0])).certificate;
        this.assertJSONEquals(JSONWebKey.build((Certificate)certificate), "src/test/resources/jwk/rsa_pss_public_key_2048_certificate.json");
    }

    @Test
    public void embedded_jwk() {
        JWT jwt = new JWT();
        jwt.addClaim("foo", (Object)"bar");
        RSAPrivateKey privateKey = (RSAPrivateKey)PEM.decode((Path)Paths.get("src/test/resources/rsa_private_key_2048.pem", new String[0])).getPrivateKey();
        RSAPublicKey publicKey = (RSAPublicKey)PEM.decode((Path)Paths.get("src/test/resources/rsa_public_key_2048.pem", new String[0])).getPublicKey();
        JSONWebKey jwk = JSONWebKey.build((PublicKey)publicKey);
        RSASigner signer = RSASigner.newSHA256Signer((PrivateKey)privateKey);
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)signer, h -> {
            h.set("cty", (Object)"application/json");
            h.set("jwk", (Object)jwk);
        });
        Header header = JWTUtils.decodeHeader((String)encodedJWT);
        Assert.assertEquals((Object)header.get("cty"), (Object)"application/json");
        Assert.assertEquals(((Map)header.get("jwk")).get("e"), (Object)jwk.e);
        Assert.assertEquals(((Map)header.get("jwk")).get("kty"), (Object)jwk.kty.name());
        Assert.assertEquals(((Map)header.get("jwk")).get("n"), (Object)jwk.n);
        Assert.assertEquals(((Map)header.get("jwk")).get("use"), (Object)jwk.use);
    }

    @Test
    public void rsa_public() throws Exception {
        RSAPublicKey pkcs1PublicKey = (RSAPublicKey)PEM.decode((Path)Paths.get("src/test/resources/rsa_public_key_2048.pem", new String[0])).getPublicKey();
        this.assertJSONEquals(JSONWebKey.build((PublicKey)pkcs1PublicKey), "src/test/resources/jwk/rsa_public_key_2048.json");
        RSAPublicKey x509PublicKey = (RSAPublicKey)PEM.decode((Path)Paths.get("src/test/resources/rsa_public_key_x509.pem", new String[0])).getPublicKey();
        this.assertJSONEquals(JSONWebKey.build((PublicKey)x509PublicKey), "src/test/resources/jwk/rsa_public_key_x509.json");
        Certificate cert1 = PEM.decode((Path)Paths.get((String)"src/test/resources/rsa_certificate_2048.pem", (String[])new String[0])).certificate;
        this.assertJSONEquals(JSONWebKey.build((Certificate)cert1), "src/test/resources/jwk/rsa_certificate_2048.json");
        this.assertJSONEquals(JSONWebKey.build((String)new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_certificate_2048.pem", new String[0])))), "src/test/resources/jwk/rsa_certificate_2048.json");
        Certificate cert2 = PEM.decode((Path)Paths.get((String)"src/test/resources/rsa_certificate_gd_bundle_g2.pem", (String[])new String[0])).certificate;
        this.assertJSONEquals(JSONWebKey.build((Certificate)cert2), "src/test/resources/jwk/rsa_certificate_gd_bundle_g2.json");
    }

    @Test(invocationCount=100)
    public void eddsa_private() throws Exception {
        EdECPrivateKey key25519 = (EdECPrivateKey)PEM.decode((Path)Paths.get("src/test/resources/ed_dsa_ed25519_private_key.pem", new String[0])).getPrivateKey();
        this.assertJSONEquals(JSONWebKey.build((PrivateKey)key25519), "src/test/resources/jwk/ed_dsa_ed25519_private_key.json");
        EdECPrivateKey key448 = (EdECPrivateKey)PEM.decode((Path)Paths.get("src/test/resources/ed_dsa_ed448_private_key.pem", new String[0])).getPrivateKey();
        this.assertJSONEquals(JSONWebKey.build((PrivateKey)key448), "src/test/resources/jwk/ed_dsa_ed448_private_key.json");
    }

    @Test(invocationCount=100)
    public void eddsa_public() throws Exception {
        EdECPublicKey key25519 = (EdECPublicKey)PEM.decode((Path)Paths.get("src/test/resources/ed_dsa_ed25519_public_key.pem", new String[0])).getPublicKey();
        this.assertJSONEquals(JSONWebKey.build((PublicKey)key25519), "src/test/resources/jwk/ed_dsa_ed25519_public_key.json");
        Certificate cert25519 = PEM.decode((Path)Paths.get((String)"src/test/resources/ed_dsa_ed25519_certificate.pem", (String[])new String[0])).certificate;
        this.assertJSONEquals(JSONWebKey.build((Certificate)cert25519), "src/test/resources/jwk/ed_dsa_ed25519_certificate.json");
        EdECPublicKey key448 = (EdECPublicKey)PEM.decode((Path)Paths.get("src/test/resources/ed_dsa_ed448_public_key.pem", new String[0])).getPublicKey();
        this.assertJSONEquals(JSONWebKey.build((PublicKey)key448), "src/test/resources/jwk/ed_dsa_ed448_public_key.json");
        Certificate cert448 = PEM.decode((Path)Paths.get((String)"src/test/resources/ed_dsa_ed448_certificate.pem", (String[])new String[0])).certificate;
        this.assertJSONEquals(JSONWebKey.build((Certificate)cert448), "src/test/resources/jwk/ed_dsa_ed448_certificate.json");
    }
}

