/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import com.sun.net.httpserver.HttpServer;
import io.fusionauth.domain.Buildable;
import io.fusionauth.http.BuilderHTTPHandler;
import io.fusionauth.http.ExpectedResponse;
import io.fusionauth.http.ExpectedResponseBuilder;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;

public class HttpServerBuilder
implements Buildable<HttpServerBuilder> {
    public BuilderHTTPHandler handler;
    public int port;
    public Map<String, ExpectedResponse> responses = new HashMap<String, ExpectedResponse>();
    public HttpServer server;

    public HttpServer build() {
        if (this.port == 0) {
            throw new IllegalStateException("You forgot to set the port.");
        }
        for (ExpectedResponse result : this.responses.values()) {
            if (result.responseFile == null) continue;
            try {
                result.response = new String(Files.readAllBytes(result.responseFile.toAbsolutePath()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            InetSocketAddress addr = new InetSocketAddress(this.port);
            this.server = HttpServer.create(addr, 0);
            this.handler = new BuilderHTTPHandler(this.responses);
            this.server.createContext("/", this.handler);
            this.server.start();
            return this.server;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ExpectedResponseBuilder handleURI(String uri) {
        return new ExpectedResponseBuilder(this, uri);
    }

    public HttpServerBuilder listenOn(int port) {
        this.port = port;
        return this;
    }
}

