/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.der;

import io.fusionauth.der.DerOutputStream;
import io.fusionauth.der.DerValue;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DerOutputStreamTest {
    @Test
    public void long_binaryString() throws Exception {
        for (int length : new int[]{127, 255, 65535, 0xFFFFFF, 0x1000001}) {
            String input = new String(new char[length]).replace('\u0000', '$');
            byte[] bytes = input.getBytes(StandardCharsets.UTF_8);
            DerValue value = new DerValue(3, bytes);
            DerOutputStream os = new DerOutputStream();
            os.writeValue(value);
            byte[] output = os.toByteArray();
            Assert.assertNotNull((Object)output);
            if (length < 128) {
                Assert.assertEquals((int)output.length, (int)(length + 2));
                Assert.assertEquals((int)output[1], (int)bytes.length, (String)("For length length [" + length + "]"));
                continue;
            }
            if (length < 256) {
                Assert.assertEquals((int)output.length, (int)(length + 3));
                Assert.assertEquals((int)ByteBuffer.wrap(new byte[]{0, output[2]}).getShort(), (int)bytes.length, (String)("For length length [" + length + "]"));
                continue;
            }
            if (length < 65536) {
                Assert.assertEquals((int)output.length, (int)(length + 4));
                Assert.assertEquals((int)ByteBuffer.wrap(new byte[]{0, 0, output[2], output[3]}).getInt(), (int)bytes.length, (String)("For length length [" + length + "]"));
                continue;
            }
            if (length < 0x1000000) {
                Assert.assertEquals((int)output.length, (int)(length + 5));
                Assert.assertEquals((int)ByteBuffer.wrap(new byte[]{0, output[2], output[3], output[4]}).getInt(), (int)bytes.length, (String)("For length length [" + length + "]"));
                continue;
            }
            Assert.assertEquals((int)output.length, (int)(length + 6));
            Assert.assertEquals((int)ByteBuffer.wrap(new byte[]{output[2], output[3], output[4], output[5]}).getInt(), (int)bytes.length, (String)("For length length [" + length + "]"));
        }
    }
}

