/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth;

import com.sun.net.httpserver.HttpServer;
import io.fusionauth.http.BuilderHTTPHandler;
import io.fusionauth.http.HttpServerBuilder;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeSuite;

public abstract class BaseTest {
    public static boolean FipsEnabled;
    public List<BuilderHTTPHandler> httpHandlers = new ArrayList<BuilderHTTPHandler>();
    public List<HttpServer> httpServers = new ArrayList<HttpServer>();

    @BeforeSuite
    public void beforeSuite() {
        FipsEnabled = Boolean.getBoolean("test.fips");
        if (FipsEnabled) {
            System.setProperty("org.bouncycastle.fips.approved_only", "true");
            Security.insertProviderAt((Provider)new BouncyCastleFipsProvider(), 1);
        }
        System.out.printf("Testing in %s mode with security provider [%s]%n", FipsEnabled ? "FIPS" : "the default JCA", Security.getProviders()[0].getClass().getCanonicalName());
    }

    @AfterMethod
    public void afterMethod(ITestResult result) {
        for (HttpServer httpServer : this.httpServers) {
            try {
                httpServer.stop(0);
            }
            catch (Exception exception) {}
        }
    }

    protected void startHttpServer(ThrowingConsumer<HttpServerBuilder> consumer) throws Exception {
        HttpServerBuilder builder = new HttpServerBuilder();
        consumer.accept(builder);
        this.startHttpServer(builder);
    }

    public void startHttpServer(HttpServerBuilder builder) {
        this.httpServers.add(builder.build());
        this.httpHandlers.add(builder.handler);
    }

    public static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

