/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.security;

import io.fusionauth.der.DerInputStream;
import io.fusionauth.der.DerValue;
import io.fusionauth.der.ObjectIdentifier;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.EdECKey;
import java.security.interfaces.EdECPrivateKey;
import java.security.interfaces.EdECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.NamedParameterSpec;
import java.util.Arrays;

public class KeyUtils {
    public static String getCurveName(Key key) throws IOException {
        String oid;
        return switch (oid = KeyUtils.getCurveOID(key).decode()) {
            case "1.2.840.10045.3.1.7" -> "P-256";
            case "1.3.132.0.34" -> "P-384";
            case "1.3.132.0.35" -> "P-521";
            case "1.3.101.112" -> "Ed25519";
            case "1.3.101.113" -> "Ed448";
            default -> null;
        };
    }

    public static ObjectIdentifier getCurveOID(Key key) throws IOException {
        DerValue[] sequence = new DerInputStream(key.getEncoded()).getSequence();
        if (key instanceof PrivateKey) {
            if (key instanceof EdECPrivateKey) {
                return sequence[1].getOID();
            }
            sequence[1].getOID();
            return sequence[1].getOID();
        }
        if (key instanceof EdECPublicKey) {
            return sequence[0].getOID();
        }
        sequence[0].getOID();
        return sequence[0].getOID();
    }

    public static byte[] deriveEdDSAPublicKeyFromPrivate(final byte[] privateKey, String curve) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        String algorithm;
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(curve);
        int expectedByteLength = switch (algorithm = keyPairGenerator.getAlgorithm()) {
            case "Ed25519" -> 32;
            case "Ed448" -> 57;
            default -> throw new IllegalArgumentException("You specified an unsupported algorithm. The algorithm [" + algorithm + "] is not supported. You must use Ed25519 or Ed448.");
        };
        if (privateKey.length != expectedByteLength) {
            throw new IllegalArgumentException("The provided privateKey length is unexpected. Expected [" + expectedByteLength + "] but found [" + privateKey.length + "]");
        }
        keyPairGenerator.initialize(new NamedParameterSpec(curve), new SecureRandom(){

            @Override
            public void nextBytes(byte[] bytes) {
                if (bytes.length != privateKey.length) {
                    throw new IllegalStateException("Provided bytes array is not large enough for the key. Expected [" + privateKey.length + "] but found [" + bytes.length + "]");
                }
                System.arraycopy(privateKey, 0, bytes, 0, privateKey.length);
            }
        });
        byte[] spki = keyPairGenerator.generateKeyPair().getPublic().getEncoded();
        return Arrays.copyOfRange(spki, spki.length - privateKey.length, spki.length);
    }

    public static int getKeyLength(Key key) {
        if (key instanceof ECKey) {
            int bytes;
            if (key instanceof ECPublicKey) {
                ECPublicKey ecPublicKey = (ECPublicKey)key;
                bytes = ecPublicKey.getW().getAffineX().toByteArray().length;
            } else {
                ECPrivateKey ecPrivateKey = (ECPrivateKey)key;
                bytes = ecPrivateKey.getS().toByteArray().length;
            }
            if (bytes >= 63 && bytes <= 66) {
                return 521;
            }
            int mod = bytes % 8;
            if (mod >= 2) {
                bytes += 8 - mod;
            }
            return bytes / 8 * 8 * 8;
        }
        if (key instanceof RSAKey) {
            RSAKey rsaKey = (RSAKey)((Object)key);
            return rsaKey.getModulus().bitLength();
        }
        if (key instanceof EdECKey) {
            EdECKey edECKey = (EdECKey)((Object)key);
            String curve = edECKey.getParams().getName();
            if ("Ed25519".equals(curve)) {
                return 32;
            }
            if ("Ed448".equals(curve)) {
                return 57;
            }
        }
        throw new IllegalArgumentException();
    }
}

