/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.domain;

import java.util.Locale;

public enum Algorithm {
    Ed25519("Ed25519"),
    Ed448("Ed448"),
    ES256("SHA256withECDSA"),
    ES384("SHA384withECDSA"),
    ES512("SHA512withECDSA"),
    HS256("HmacSHA256"),
    HS384("HmacSHA384"),
    HS512("HmacSHA512"),
    PS256("SHA256withRSAandMGF1"),
    PS384("SHA384withRSAandMGF1"),
    PS512("SHA512withRSAandMGF1"),
    RS256("SHA256withRSA"),
    RS384("SHA384withRSA"),
    RS512("SHA512withRSA"),
    none("None");

    public final String algorithm;

    private Algorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public static Algorithm fromName(String name) {
        for (Algorithm alg : Algorithm.values()) {
            if (!alg.getName().toUpperCase(Locale.ROOT).equals(name.toUpperCase(Locale.ROOT))) continue;
            return alg;
        }
        return null;
    }

    public String getName() {
        return this.algorithm;
    }

    public String getDigest() {
        return switch (this) {
            case PS256 -> "SHA-256";
            case PS384 -> "SHA-384";
            case PS512 -> "SHA-512";
            default -> throw new IllegalStateException("An incompatible algorithm was provided, this method is only used for RSASSA-PSS algorithms.");
        };
    }

    public int getSaltLength() {
        return switch (this) {
            case PS256 -> 32;
            case PS384 -> 48;
            case PS512 -> 64;
            default -> throw new IllegalStateException("An incompatible algorithm was provided, this method is only used for RSASSA-PSS algorithms.");
        };
    }
}

