/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.util;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class Normalizer {
    public static <T> void deDuplicate(List<T> list) {
        if (list == null) {
            return;
        }
        HashSet set = new HashSet();
        list.removeIf(o -> !set.add(o));
    }

    public static String lineReturns(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("\\r\\n|\\r", "\n");
    }

    public static <T> void lineReturnsMap(Map<T, String> map) {
        map.forEach((key, value) -> {
            if (value != null) {
                map.put(key, value.replaceAll("\\r\\n|\\r", "\n"));
            }
        });
    }

    public static <T> void removeEmpty(List<T> list) {
        if (list == null) {
            return;
        }
        list.removeIf(Objects::isNull);
    }

    public static <T, U> void removeEmpty(Map<T, U> map) {
        if (map == null) {
            return;
        }
        map.keySet().removeIf(key -> map.get(key) == null);
    }

    public static String removeLineReturns(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("\\r\\n|\\r|\\n", "");
    }

    public static <T extends Collection<String>> void toLowerCase(Collection<String> collection, Supplier<T> supplier) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Collection lc = (Collection)collection.stream().map(String::toLowerCase).collect(Collectors.toCollection(supplier));
        collection.clear();
        collection.addAll(lc);
    }

    public static String toLowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String toUpperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static String trim(String str) {
        if (str == null) {
            return null;
        }
        return str.trim();
    }

    public static <T> void trimMap(Map<T, String> map) {
        map.forEach((key, value) -> {
            if (value != null) {
                map.put(key, value.trim());
            }
        });
    }

    public static String trimToNull(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).isEmpty()) {
            return null;
        }
        return str;
    }

    public static ZonedDateTime truncateToMilliseconds(ZonedDateTime time) {
        if (time == null) {
            return null;
        }
        return time.truncatedTo(ChronoUnit.MILLIS);
    }
}

