/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.provider;

import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import io.fusionauth.domain.provider.HYPRApplicationConfiguration;
import io.fusionauth.domain.provider.IdentityProviderType;
import io.fusionauth.domain.provider.PasswordlessIdentityProvider;
import java.net.URI;
import java.util.Objects;
import java.util.UUID;

public class HYPRIdentityProvider
extends BaseIdentityProvider<HYPRApplicationConfiguration>
implements Buildable<HYPRIdentityProvider>,
PasswordlessIdentityProvider {
    public String relyingPartyApplicationId;
    public URI relyingPartyURL;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HYPRIdentityProvider)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HYPRIdentityProvider that = (HYPRIdentityProvider)o;
        return Objects.equals(this.relyingPartyApplicationId, that.relyingPartyApplicationId) && Objects.equals(this.relyingPartyURL, that.relyingPartyURL);
    }

    @Override
    public IdentityProviderType getType() {
        return IdentityProviderType.HYPR;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.relyingPartyApplicationId, this.relyingPartyURL);
    }

    public String lookupRelyingPartyApplicationId(UUID applicationId) {
        return this.lookup(() -> this.relyingPartyApplicationId, () -> this.app(applicationId, (D app) -> app.relyingPartyApplicationId));
    }

    public URI lookupRelyingPartyURL(UUID applicationId) {
        return this.lookup(() -> this.relyingPartyURL, () -> this.app(applicationId, (D app) -> app.relyingPartyURL));
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

