/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.EventInfo;
import io.fusionauth.domain.User;
import io.fusionauth.domain.UserRegistration;
import io.fusionauth.domain.event.BaseUserEvent;
import io.fusionauth.domain.event.EventType;
import java.util.Objects;
import java.util.UUID;

public class UserRegistrationVerifiedEvent
extends BaseUserEvent
implements Buildable<UserRegistrationVerifiedEvent> {
    public UUID applicationId;
    public UserRegistration registration;

    public UserRegistrationVerifiedEvent(EventInfo info, UUID applicationId, UserRegistration registration, User user) {
        super(info, user);
        this.user.getRegistrations().clear();
        this.applicationId = applicationId;
        this.registration = registration;
    }

    @JacksonConstructor
    private UserRegistrationVerifiedEvent() {
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        UserRegistrationVerifiedEvent that = (UserRegistrationVerifiedEvent)o;
        return Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.registration, that.registration);
    }

    @Override
    public EventType getType() {
        return EventType.UserRegistrationVerified;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.applicationId, this.registration);
    }
}

