/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.EventInfo;
import io.fusionauth.domain.User;
import io.fusionauth.domain.UserRegistration;
import io.fusionauth.domain.event.BaseUserEvent;
import io.fusionauth.domain.event.EventType;
import io.fusionauth.domain.event.NonTransactionalEvent;
import java.util.Objects;
import java.util.UUID;

public class UserRegistrationDeleteCompleteEvent
extends BaseUserEvent
implements Buildable<UserRegistrationDeleteCompleteEvent>,
NonTransactionalEvent {
    public UUID applicationId;
    public UserRegistration registration;

    public UserRegistrationDeleteCompleteEvent(EventInfo info, UUID applicationId, UserRegistration registration, User user) {
        super(info, user);
        this.user.getRegistrations().clear();
        this.applicationId = applicationId;
        this.registration = registration;
    }

    @JacksonConstructor
    private UserRegistrationDeleteCompleteEvent() {
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        UserRegistrationDeleteCompleteEvent that = (UserRegistrationDeleteCompleteEvent)o;
        return Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.registration, that.registration);
    }

    @Override
    public EventType getType() {
        return EventType.UserRegistrationDeleteComplete;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.applicationId, this.registration);
    }
}

