/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.LocalizedStrings;
import io.fusionauth.domain.TransactionType;
import io.fusionauth.domain.UserActionOption;
import io.fusionauth.domain.util.Normalizer;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class UserAction
implements Comparable<UserAction>,
Buildable<UserAction> {
    public boolean active;
    public UUID cancelEmailTemplateId;
    public UUID endEmailTemplateId;
    public UUID id;
    public boolean includeEmailInEventJSON;
    public ZonedDateTime insertInstant;
    public ZonedDateTime lastUpdateInstant;
    public LocalizedStrings localizedNames;
    public UUID modifyEmailTemplateId;
    public String name;
    public List<UserActionOption> options = new ArrayList<UserActionOption>();
    public boolean preventLogin;
    public boolean sendEndEvent = true;
    public UUID startEmailTemplateId;
    public boolean temporal;
    public TransactionType transactionType;
    public boolean userEmailingEnabled;
    public boolean userNotificationsEnabled;

    public UserAction() {
    }

    public UserAction(String name) {
        this.name = name;
    }

    public UserAction(UUID id, String name, boolean active, LocalizedStrings localizedNames, boolean preventLogin, boolean sendEndEvent, boolean temporal, boolean userNotificationsEnabled, boolean userEmailingEnabled, boolean includeEmailInEventJSON, UUID startEmailTemplateId, UUID modifyEmailTemplateId, UUID cancelEmailTemplateId, UUID endEmailTemplateId, UserActionOption ... options) {
        this.id = id;
        this.active = active;
        this.name = name;
        this.includeEmailInEventJSON = includeEmailInEventJSON;
        this.localizedNames = localizedNames;
        this.preventLogin = preventLogin;
        this.sendEndEvent = sendEndEvent;
        this.temporal = temporal;
        this.userNotificationsEnabled = userNotificationsEnabled;
        this.startEmailTemplateId = startEmailTemplateId;
        this.modifyEmailTemplateId = modifyEmailTemplateId;
        this.cancelEmailTemplateId = cancelEmailTemplateId;
        this.endEmailTemplateId = endEmailTemplateId;
        this.userEmailingEnabled = userEmailingEnabled;
        Collections.addAll(this.options, options);
    }

    @Override
    public int compareTo(UserAction o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserAction)) {
            return false;
        }
        UserAction that = (UserAction)o;
        return this.active == that.active && this.includeEmailInEventJSON == that.includeEmailInEventJSON && this.preventLogin == that.preventLogin && this.sendEndEvent == that.sendEndEvent && this.temporal == that.temporal && this.userEmailingEnabled == that.userEmailingEnabled && this.userNotificationsEnabled == that.userNotificationsEnabled && Objects.equals(this.cancelEmailTemplateId, that.cancelEmailTemplateId) && Objects.equals(this.endEmailTemplateId, that.endEmailTemplateId) && Objects.equals(this.id, that.id) && Objects.equals(this.localizedNames, that.localizedNames) && Objects.equals(this.modifyEmailTemplateId, that.modifyEmailTemplateId) && Objects.equals(this.name, that.name) && Objects.equals(this.options, that.options) && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.lastUpdateInstant, that.lastUpdateInstant) && Objects.equals(this.startEmailTemplateId, that.startEmailTemplateId) && this.transactionType == that.transactionType;
    }

    @JsonIgnore
    public UserActionOption getOption(String name) {
        if (name == null) {
            return null;
        }
        for (UserActionOption key : this.options) {
            if (!key.name.equals(name)) continue;
            return key;
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.active, this.cancelEmailTemplateId, this.endEmailTemplateId, this.id, this.includeEmailInEventJSON, this.localizedNames, this.modifyEmailTemplateId, this.name, this.options, this.preventLogin, this.insertInstant, this.lastUpdateInstant, this.sendEndEvent, this.startEmailTemplateId, this.temporal, this.transactionType, this.userEmailingEnabled, this.userNotificationsEnabled});
    }

    public void normalize() {
        this.name = Normalizer.trim(this.name);
        if (this.localizedNames != null) {
            this.localizedNames.normalize();
        }
        if (this.options != null) {
            this.options.forEach(UserActionOption::normalize);
        }
    }

    public void sortOptions() {
        Collections.sort(this.options);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

