/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.webauthn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.fusionauth.domain.webauthn.CoseEllipticCurve;
import io.fusionauth.domain.webauthn.CoseKeyType;
import java.util.HashMap;
import java.util.Map;

public enum CoseAlgorithmIdentifier {
    ES256(-7L, "SHA256withECDSA", CoseKeyType.EC2),
    ES384(-35L, "SHA384withECDSA", CoseKeyType.EC2),
    ES512(-36L, "SHA512withECDSA", CoseKeyType.EC2),
    RS256(-257L, "SHA256withRSA", CoseKeyType.RSA),
    RS384(-258L, "SHA384withRSA", CoseKeyType.RSA),
    RS512(-259L, "SHA512withRSA", CoseKeyType.RSA),
    PS256(-37L, "SHA-256", CoseKeyType.RSA),
    PS384(-38L, "SHA-384", CoseKeyType.RSA),
    PS512(-39L, "SHA-512", CoseKeyType.RSA);

    private static final Map<Long, CoseAlgorithmIdentifier> valueMap;
    public final String description;
    public final CoseKeyType keyType;
    @JsonValue
    public final long registryId;

    private CoseAlgorithmIdentifier(long registryId, String description, CoseKeyType keyType) {
        this.registryId = registryId;
        this.description = description;
        this.keyType = keyType;
    }

    @JsonCreator
    public static CoseAlgorithmIdentifier forValue(long registryId) {
        return valueMap.get(registryId);
    }

    public CoseEllipticCurve getCurve() {
        switch (this) {
            case ES256: {
                return CoseEllipticCurve.P256;
            }
            case ES384: {
                return CoseEllipticCurve.P384;
            }
            case ES512: {
                return CoseEllipticCurve.P521;
            }
        }
        throw new IllegalStateException("An incompatible algorithm was provided, this method is only used for ECDSA algorithms.");
    }

    public int getSaltLength() {
        switch (this) {
            case PS256: {
                return 32;
            }
            case PS384: {
                return 48;
            }
            case PS512: {
                return 64;
            }
        }
        throw new IllegalStateException("An incompatible algorithm was provided, this method is only used for RSASSA-PSS algorithms.");
    }

    public String toString() {
        return String.format("%s (%d)", this.description, this.registryId);
    }

    static {
        valueMap = new HashMap<Long, CoseAlgorithmIdentifier>();
        for (CoseAlgorithmIdentifier a : CoseAlgorithmIdentifier.values()) {
            valueMap.put(a.registryId, a);
        }
    }
}

