/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.oauth2;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.oauth2.OAuthResponse;
import io.fusionauth.domain.oauth2.TokenType;
import java.net.URI;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.UUID;

public class AccessToken
implements OAuthResponse,
Buildable<AccessToken> {
    @JsonIgnore
    public String clientId;
    @JsonProperty(value="expires_in")
    public Integer expiresIn;
    @JsonProperty(value="id_token")
    public String idToken;
    @JsonIgnore
    public URI redirectURI;
    @JsonProperty(value="refresh_token")
    public String refreshToken;
    @JsonProperty(value="refresh_token_id")
    public UUID refreshTokenId;
    public String scope;
    @JsonProperty(value="access_token")
    public String token;
    @JsonProperty(value="token_type")
    public TokenType tokenType;
    public UUID userId;
    @JsonIgnore
    private ZonedDateTime createInstant;

    @JacksonConstructor
    public AccessToken() {
    }

    public AccessToken(String token, String clientId, Integer expiresIn, URI redirectURI, TokenType tokenType, UUID userId) {
        this.clientId = clientId;
        this.createInstant = ZonedDateTime.now(ZoneOffset.UTC);
        this.expiresIn = expiresIn;
        this.redirectURI = redirectURI;
        this.token = token;
        this.tokenType = tokenType;
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessToken that = (AccessToken)o;
        return Objects.equals(this.clientId, that.clientId) && Objects.equals(this.expiresIn, that.expiresIn) && Objects.equals(this.idToken, that.idToken) && Objects.equals(this.redirectURI, that.redirectURI) && Objects.equals(this.refreshToken, that.refreshToken) && Objects.equals(this.refreshTokenId, that.refreshTokenId) && Objects.equals(this.scope, that.scope) && Objects.equals(this.token, that.token) && this.tokenType == that.tokenType && Objects.equals(this.userId, that.userId) && Objects.equals(this.createInstant, that.createInstant);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.expiresIn, this.idToken, this.redirectURI, this.refreshToken, this.refreshTokenId, this.scope, this.token, this.tokenType, this.userId, this.createInstant});
    }

    public void setTokenType(String tokenType) {
        this.tokenType = TokenType.fromName(tokenType);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

