/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.fusionauth.domain.event.InstanceEvent;
import io.fusionauth.domain.event.NonTransactionalEvent;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum EventType {
    JWTPublicKeyUpdate("jwt.public-key.update"),
    JWTRefreshTokenRevoke("jwt.refresh-token.revoke"),
    JWTRefresh("jwt.refresh"),
    AuditLogCreate("audit-log.create"),
    EventLogCreate("event-log.create"),
    KickstartSuccess("kickstart.success"),
    GroupCreate("group.create"),
    GroupCreateComplete("group.create.complete"),
    GroupDelete("group.delete"),
    GroupDeleteComplete("group.delete.complete"),
    GroupMemberAdd("group.member.add"),
    GroupMemberAddComplete("group.member.add.complete"),
    GroupMemberRemove("group.member.remove"),
    GroupMemberRemoveComplete("group.member.remove.complete"),
    GroupMemberUpdate("group.member.update"),
    GroupMemberUpdateComplete("group.member.update.complete"),
    GroupUpdate("group.update"),
    GroupUpdateComplete("group.update.complete"),
    UserAction("user.action"),
    UserBulkCreate("user.bulk.create"),
    UserCreate("user.create"),
    UserCreateComplete("user.create.complete"),
    UserDeactivate("user.deactivate"),
    UserDelete("user.delete"),
    UserDeleteComplete("user.delete.complete"),
    UserEmailUpdate("user.email.update"),
    UserEmailVerified("user.email.verified"),
    UserIdentityProviderLink("user.identity-provider.link"),
    UserIdentityProviderUnlink("user.identity-provider.unlink"),
    UserLoginIdDuplicateOnCreate("user.loginId.duplicate.create"),
    UserLoginIdDuplicateOnUpdate("user.loginId.duplicate.update"),
    UserLoginFailed("user.login.failed"),
    UserLoginNewDevice("user.login.new-device"),
    UserLoginSuccess("user.login.success"),
    UserLoginSuspicious("user.login.suspicious"),
    UserPasswordBreach("user.password.breach"),
    UserPasswordResetSend("user.password.reset.send"),
    UserPasswordResetStart("user.password.reset.start"),
    UserPasswordResetSuccess("user.password.reset.success"),
    UserPasswordUpdate("user.password.update"),
    UserReactivate("user.reactivate"),
    UserRegistrationCreate("user.registration.create"),
    UserRegistrationCreateComplete("user.registration.create.complete"),
    UserRegistrationDelete("user.registration.delete"),
    UserRegistrationDeleteComplete("user.registration.delete.complete"),
    UserRegistrationUpdate("user.registration.update"),
    UserRegistrationUpdateComplete("user.registration.update.complete"),
    UserRegistrationVerified("user.registration.verified"),
    UserTwoFactorMethodAdd("user.two-factor.method.add"),
    UserTwoFactorMethodRemove("user.two-factor.method.remove"),
    UserUpdate("user.update"),
    UserUpdateComplete("user.update.complete"),
    Test("test"),
    UserIdentityVerified("user.identity.verified"),
    UserIdentityUpdate("user.identity.update");

    private static final Map<String, EventType> nameMap;
    private final String eventName;

    private EventType(String eventName) {
        this.eventName = eventName;
    }

    public static List<EventType> allTypes() {
        return Arrays.asList(AuditLogCreate, EventLogCreate, JWTPublicKeyUpdate, JWTRefreshTokenRevoke, JWTRefresh, KickstartSuccess, GroupCreate, GroupCreateComplete, GroupDelete, GroupDeleteComplete, GroupMemberAdd, GroupMemberAddComplete, GroupMemberRemove, GroupMemberRemoveComplete, GroupMemberUpdate, GroupMemberUpdateComplete, GroupUpdate, GroupUpdateComplete, UserAction, UserBulkCreate, UserCreate, UserCreateComplete, UserDeactivate, UserDelete, UserDeleteComplete, UserEmailUpdate, UserEmailVerified, UserIdentityProviderLink, UserIdentityProviderUnlink, UserIdentityUpdate, UserIdentityVerified, UserLoginIdDuplicateOnCreate, UserLoginIdDuplicateOnUpdate, UserLoginFailed, UserLoginNewDevice, UserLoginSuccess, UserLoginSuspicious, UserPasswordBreach, UserPasswordResetSend, UserPasswordResetStart, UserPasswordResetSuccess, UserPasswordUpdate, UserReactivate, UserRegistrationCreate, UserRegistrationCreateComplete, UserRegistrationDelete, UserRegistrationDeleteComplete, UserRegistrationUpdate, UserRegistrationUpdateComplete, UserRegistrationVerified, UserTwoFactorMethodAdd, UserTwoFactorMethodRemove, UserUpdate, UserUpdateComplete);
    }

    @JsonCreator
    public static EventType forValue(String value) {
        return nameMap.get(value);
    }

    @JsonValue
    public String eventName() {
        return this.eventName;
    }

    public boolean isInstanceEvent() {
        try {
            Constructor<?> ctor = Class.forName(((Object)((Object)this)).getClass().getPackage().getName() + "." + this.name() + "Event").getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return ctor.newInstance(new Object[0]) instanceof InstanceEvent;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isTransactionalEvent() {
        try {
            Constructor<?> ctor = Class.forName(((Object)((Object)this)).getClass().getPackage().getName() + "." + this.name() + "Event").getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return !(ctor.newInstance(new Object[0]) instanceof NonTransactionalEvent);
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        nameMap = new HashMap<String, EventType>(EventType.values().length);
        for (EventType eventType : EventType.values()) {
            nameMap.put(eventType.eventName(), eventType);
        }
    }
}

