/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.Tenantable;
import io.fusionauth.domain.webauthn.AttestationType;
import io.fusionauth.domain.webauthn.CoseAlgorithmIdentifier;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class WebAuthnCredential
implements Tenantable,
Buildable<WebAuthnCredential> {
    public CoseAlgorithmIdentifier algorithm;
    public AttestationType attestationType;
    public boolean authenticatorSupportsUserVerification;
    public String credentialId;
    public Map<String, Object> data = new LinkedHashMap<String, Object>();
    public boolean discoverable;
    public String displayName;
    public UUID id;
    public ZonedDateTime insertInstant;
    public ZonedDateTime lastUseInstant;
    public String name;
    public String publicKey;
    public String relyingPartyId;
    public int signCount;
    public UUID tenantId;
    public List<String> transports = new ArrayList<String>();
    public String userAgent;
    public UUID userId;

    @JacksonConstructor
    public WebAuthnCredential() {
    }

    public WebAuthnCredential(WebAuthnCredential other) {
        this.algorithm = other.algorithm;
        this.attestationType = other.attestationType;
        this.authenticatorSupportsUserVerification = other.authenticatorSupportsUserVerification;
        this.credentialId = other.credentialId;
        if (other.data != null) {
            this.data.putAll(other.data);
        }
        this.discoverable = other.discoverable;
        this.displayName = other.displayName;
        this.id = other.id;
        this.insertInstant = other.insertInstant;
        this.name = other.name;
        this.lastUseInstant = other.lastUseInstant;
        this.publicKey = other.publicKey;
        this.relyingPartyId = other.relyingPartyId;
        this.signCount = other.signCount;
        this.tenantId = other.tenantId;
        if (other.transports != null) {
            this.transports.addAll(other.transports);
        }
        this.userAgent = other.userAgent;
        this.userId = other.userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebAuthnCredential that = (WebAuthnCredential)o;
        return this.authenticatorSupportsUserVerification == that.authenticatorSupportsUserVerification && this.discoverable == that.discoverable && this.signCount == that.signCount && this.algorithm == that.algorithm && this.attestationType == that.attestationType && Objects.equals(this.credentialId, that.credentialId) && Objects.equals(this.data, that.data) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.id, that.id) && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.lastUseInstant, that.lastUseInstant) && Objects.equals(this.name, that.name) && Objects.equals(this.publicKey, that.publicKey) && Objects.equals(this.relyingPartyId, that.relyingPartyId) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.transports, that.transports) && Objects.equals(this.userAgent, that.userAgent) && Objects.equals(this.userId, that.userId);
    }

    @Override
    public UUID getTenantId() {
        return this.tenantId;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.algorithm, this.attestationType, this.authenticatorSupportsUserVerification, this.credentialId, this.data, this.discoverable, this.displayName, this.id, this.insertInstant, this.lastUseInstant, this.name, this.publicKey, this.relyingPartyId, this.signCount, this.tenantId, this.transports, this.userAgent, this.userId});
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

