/*
 * Copyright (c) 2021, FusionAuth, All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package io.fusionauth.domain.api;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.EntityGrant;

/**
 * Entity grant API response object.
 *
 * @author Brian Pontarelli
 */
public class EntityGrantResponse {
  public final List<EntityGrant> grants = new ArrayList<>();

  public EntityGrant grant;

  @JacksonConstructor
  public EntityGrantResponse() {
  }

  public EntityGrantResponse(EntityGrant grant) {
    this.grant = grant;
    this.grant.entity.type.permissions.sort(Comparator.comparing(p -> p.name));
  }

  public EntityGrantResponse(List<EntityGrant> grants) {
    this.grants.addAll(grants);
    this.grants.forEach(g -> g.entity.type.permissions.sort(Comparator.comparing(p -> p.name)));
  }
}
