/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.search;

import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.provider.IdentityProviderType;
import io.fusionauth.domain.search.BaseSearchCriteria;
import io.fusionauth.domain.util.SQLTools;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class IdentityProviderSearchCriteria
extends BaseSearchCriteria {
    public static final Map<String, String> SortableFields = new LinkedHashMap<String, String>();
    public UUID applicationId;
    public String name;
    public IdentityProviderType type;

    @JacksonConstructor
    public IdentityProviderSearchCriteria() {
    }

    @Override
    public IdentityProviderSearchCriteria prepare() {
        if (this.orderBy == null) {
            this.orderBy = this.defaultOrderBy();
        }
        this.orderBy = SQLTools.normalizeOrderBy(this.orderBy, SortableFields);
        this.name = SQLTools.toSearchString(this.name);
        return this;
    }

    @Override
    public Set<String> supportedOrderByColumns() {
        return SortableFields.keySet();
    }

    @Override
    protected String defaultOrderBy() {
        return "name ASC";
    }

    static {
        SortableFields.put("id", "id");
        SortableFields.put("insertInstant", "insert_instant");
        SortableFields.put("name", "name");
        SortableFields.put("enabled", "enabled");
        SortableFields.put("type", "type");
    }
}

