/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.search;

import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.search.BaseSearchCriteria;
import io.fusionauth.domain.util.SQLTools;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class AuditLogSearchCriteria
extends BaseSearchCriteria
implements Buildable<AuditLogSearchCriteria> {
    public static final Map<String, String> SortableFields = new LinkedHashMap<String, String>();
    public ZonedDateTime end;
    public String message;
    public String newValue;
    public String oldValue;
    public String reason;
    public ZonedDateTime start;
    public String user;

    @JacksonConstructor
    public AuditLogSearchCriteria() {
    }

    public AuditLogSearchCriteria(String message, String user, ZonedDateTime start, ZonedDateTime end, String orderBy) {
        this.end = end;
        this.message = message;
        this.start = start;
        this.user = user;
        this.orderBy = orderBy;
    }

    public AuditLogSearchCriteria(String message, String user, ZonedDateTime start, ZonedDateTime end, int startRow, int numberOfResults, String orderBy) {
        this.end = end;
        this.message = message;
        this.start = start;
        this.user = user;
        this.startRow = startRow;
        this.numberOfResults = numberOfResults;
        this.orderBy = orderBy;
    }

    @Override
    public AuditLogSearchCriteria prepare() {
        if (this.orderBy == null) {
            this.orderBy = this.defaultOrderBy();
        }
        this.orderBy = SQLTools.normalizeOrderBy(this.orderBy, SortableFields);
        this.user = SQLTools.toSearchString(this.user);
        this.message = SQLTools.toSearchString(this.message);
        this.newValue = SQLTools.toSearchString(this.newValue);
        this.oldValue = SQLTools.toSearchString(this.oldValue);
        this.reason = SQLTools.toSearchString(this.reason);
        return this;
    }

    @Override
    public Set<String> supportedOrderByColumns() {
        return SortableFields.keySet();
    }

    @Override
    protected String defaultOrderBy() {
        return "insertInstant DESC";
    }

    static {
        SortableFields.put("insertInstant", "insert_instant");
        SortableFields.put("insertUser", "insert_user");
        SortableFields.put("message", "message");
    }
}

