/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.AuthenticatorConfiguration;
import io.fusionauth.domain.Buildable;
import java.util.Objects;

public class TwoFactorMethod
implements Buildable<TwoFactorMethod> {
    public static final String Authenticator = "authenticator";
    public static final String Email = "email";
    public static final String SMS = "sms";
    public AuthenticatorConfiguration authenticator;
    public String email;
    public String id;
    public Boolean lastUsed;
    public String method;
    public String mobilePhone;
    public String secret;

    @JacksonConstructor
    public TwoFactorMethod() {
    }

    public TwoFactorMethod(String method) {
        this.method = method;
    }

    public TwoFactorMethod(TwoFactorMethod other) {
        if (other.authenticator != null) {
            this.authenticator = new AuthenticatorConfiguration(other.authenticator);
        }
        this.email = other.email;
        this.id = other.id;
        this.lastUsed = other.lastUsed;
        this.method = other.method;
        this.mobilePhone = other.mobilePhone;
        this.secret = other.secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwoFactorMethod that = (TwoFactorMethod)o;
        return Objects.equals(this.authenticator, that.authenticator) && Objects.equals(this.email, that.email) && Objects.equals(this.id, that.id) && Objects.equals(this.lastUsed, that.lastUsed) && Objects.equals(this.method, that.method) && Objects.equals(this.mobilePhone, that.mobilePhone) && Objects.equals(this.secret, that.secret);
    }

    public int hashCode() {
        return Objects.hash(this.authenticator, this.email, this.id, this.lastUsed, this.method, this.mobilePhone, this.secret);
    }

    public void normalize() {
        if (this.method != null) {
            switch (this.method) {
                case "authenticator": {
                    this.email = null;
                    this.mobilePhone = null;
                    break;
                }
                case "email": {
                    this.mobilePhone = null;
                    this.secret = null;
                    break;
                }
                case "sms": {
                    this.email = null;
                    this.secret = null;
                }
            }
        }
    }

    public TwoFactorMethod secure() {
        this.secret = null;
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

