/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.ApplicationRole;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.Tenantable;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class Group
implements Buildable<Group>,
Tenantable {
    public final Map<String, Object> data = new LinkedHashMap<String, Object>();
    public UUID id;
    public ZonedDateTime insertInstant;
    public ZonedDateTime lastUpdateInstant;
    public String name;
    public Map<UUID, List<ApplicationRole>> roles = new HashMap<UUID, List<ApplicationRole>>();
    public UUID tenantId;

    @JacksonConstructor
    public Group() {
    }

    public Group(String name) {
        this.name = name;
    }

    public Group(Group other) {
        this.id = other.id;
        this.data.putAll(other.data);
        this.insertInstant = other.insertInstant;
        this.lastUpdateInstant = other.lastUpdateInstant;
        this.name = other.name;
        other.roles.forEach((k, v) -> this.roles.put((UUID)k, other.roles.get(k).stream().map(ApplicationRole::new).collect(Collectors.toList())));
        this.tenantId = other.tenantId;
    }

    public Group(UUID id, String name) {
        this.id = id;
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Group)) {
            return false;
        }
        Group group = (Group)o;
        return Objects.equals(this.data, group.data) && Objects.equals(this.id, group.id) && Objects.equals(this.name, group.name) && Objects.equals(this.roles, group.roles) && Objects.equals(this.tenantId, group.tenantId) && Objects.equals(this.insertInstant, group.insertInstant) && Objects.equals(this.lastUpdateInstant, group.lastUpdateInstant);
    }

    @Override
    public UUID getTenantId() {
        return this.tenantId;
    }

    public int hashCode() {
        return Objects.hash(this.data, this.id, this.name, this.roles, this.tenantId, this.insertInstant, this.lastUpdateInstant);
    }

    public Group sort() {
        for (List<ApplicationRole> appRoles : this.roles.values()) {
            appRoles.sort(Comparator.comparing(r -> r.name));
        }
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

