/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.provider;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.IdentityProviderLink;
import io.fusionauth.domain.User;
import io.fusionauth.domain.provider.IdentityProviderTenantConfiguration;
import io.fusionauth.domain.provider.IdentityProviderType;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class PendingIdPLink
implements Buildable<PendingIdPLink> {
    public String displayName;
    public String email;
    public UUID identityProviderId;
    public List<IdentityProviderLink> identityProviderLinks;
    public String identityProviderName;
    public IdentityProviderTenantConfiguration identityProviderTenantConfiguration;
    public IdentityProviderType identityProviderType;
    public String identityProviderUserId;
    public User user;
    public String username;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PendingIdPLink that = (PendingIdPLink)o;
        return Objects.equals(this.displayName, that.displayName) && Objects.equals(this.email, that.email) && Objects.equals(this.identityProviderId, that.identityProviderId) && Objects.equals(this.identityProviderLinks, that.identityProviderLinks) && Objects.equals(this.identityProviderName, that.identityProviderName) && this.identityProviderType == that.identityProviderType && Objects.equals(this.identityProviderUserId, that.identityProviderUserId) && Objects.equals(this.user, that.user) && Objects.equals(this.username, that.username);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.displayName, this.email, this.identityProviderId, this.identityProviderLinks, this.identityProviderName, this.identityProviderType, this.identityProviderUserId, this.user, this.username});
    }

    @JsonIgnore
    public boolean isLinkLimitExceeded() {
        if (this.identityProviderTenantConfiguration == null || this.identityProviderLinks == null) {
            return false;
        }
        if (this.identityProviderLinks.stream().anyMatch(l -> l.identityProviderUserId.equals(this.identityProviderUserId))) {
            return false;
        }
        return this.identityProviderLinks.size() >= this.identityProviderTenantConfiguration.limitUserLinkCount.maximumLinks;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

