/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.Enableable;
import io.fusionauth.domain.LocalizedIntegers;
import io.fusionauth.domain.User;
import io.fusionauth.domain.util.Normalizer;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class Consent
implements Buildable<Consent> {
    public final Map<String, Object> data = new LinkedHashMap<String, Object>();
    public UUID consentEmailTemplateId;
    public LocalizedIntegers countryMinimumAgeForSelfConsent = new LocalizedIntegers();
    public Integer defaultMinimumAgeForSelfConsent;
    public EmailPlus emailPlus = new EmailPlus();
    public UUID id;
    public ZonedDateTime insertInstant;
    public ZonedDateTime lastUpdateInstant;
    public boolean multipleValuesAllowed;
    public String name;
    public List<String> values = new ArrayList<String>();

    @JacksonConstructor
    public Consent() {
    }

    @JsonIgnore
    public boolean canSelfConsent(User user) {
        Integer ageOfSelfConsent = this.getMinimumSelfConsentAge(user);
        if (ageOfSelfConsent == 0) {
            return true;
        }
        return user.getAge() >= ageOfSelfConsent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Consent)) {
            return false;
        }
        Consent consent = (Consent)o;
        return this.multipleValuesAllowed == consent.multipleValuesAllowed && Objects.equals(this.data, consent.data) && Objects.equals(this.consentEmailTemplateId, consent.consentEmailTemplateId) && Objects.equals(this.countryMinimumAgeForSelfConsent, consent.countryMinimumAgeForSelfConsent) && Objects.equals(this.defaultMinimumAgeForSelfConsent, consent.defaultMinimumAgeForSelfConsent) && Objects.equals(this.emailPlus, consent.emailPlus) && Objects.equals(this.id, consent.id) && Objects.equals(this.insertInstant, consent.insertInstant) && Objects.equals(this.lastUpdateInstant, consent.lastUpdateInstant) && Objects.equals(this.name, consent.name) && Objects.equals(this.values, consent.values);
    }

    @JsonIgnore
    public Integer getMinimumSelfConsentAge(User user) {
        for (Locale locale : user.preferredLanguages) {
            Integer override = (Integer)this.countryMinimumAgeForSelfConsent.get(locale);
            if (override == null) continue;
            return override;
        }
        return this.defaultMinimumAgeForSelfConsent;
    }

    public int hashCode() {
        return Objects.hash(this.data, this.consentEmailTemplateId, this.countryMinimumAgeForSelfConsent, this.defaultMinimumAgeForSelfConsent, this.emailPlus, this.id, this.insertInstant, this.lastUpdateInstant, this.multipleValuesAllowed, this.name, this.values);
    }

    public void normalize() {
        if (this.values != null) {
            Normalizer.removeEmpty(this.values);
        }
        if (this.countryMinimumAgeForSelfConsent != null) {
            this.countryMinimumAgeForSelfConsent.removeEmpty();
        }
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class EmailPlus
    extends Enableable {
        public UUID emailTemplateId;
        public int maximumTimeToSendEmailInHours = 48;
        public int minimumTimeToSendEmailInHours = 24;

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EmailPlus)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EmailPlus emailPlus = (EmailPlus)o;
            return this.maximumTimeToSendEmailInHours == emailPlus.maximumTimeToSendEmailInHours && this.minimumTimeToSendEmailInHours == emailPlus.minimumTimeToSendEmailInHours && Objects.equals(this.emailTemplateId, emailPlus.emailTemplateId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.emailTemplateId, this.maximumTimeToSendEmailInHours, this.minimumTimeToSendEmailInHours);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }
}

