/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.api.email;

import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.email.EmailAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class SendRequest {
    public UUID applicationId;
    public List<String> bccAddresses;
    public List<String> ccAddresses;
    public List<Locale> preferredLanguages = new ArrayList<Locale>();
    public Map<String, Object> requestData;
    public List<EmailAddress> toAddresses;
    public List<UUID> userIds;

    @JacksonConstructor
    public SendRequest() {
    }

    public SendRequest(List<UUID> userIds, List<String> ccAddresses, List<String> bccAddresses, Map<String, Object> requestData) {
        this.userIds = userIds;
        this.ccAddresses = ccAddresses;
        this.bccAddresses = bccAddresses;
        this.requestData = requestData;
    }

    public SendRequest(List<UUID> userIds, Map<String, Object> requestData) {
        this.userIds = userIds;
        this.requestData = requestData;
    }

    public SendRequest(List<UUID> userIds) {
        this.userIds = userIds;
    }

    public SendRequest normalize() {
        this.requestData = Optional.ofNullable(this.requestData).orElseGet(HashMap::new);
        this.userIds = Optional.ofNullable(this.userIds).orElseGet(ArrayList::new);
        this.toAddresses = Optional.ofNullable(this.toAddresses).orElseGet(ArrayList::new);
        this.ccAddresses = Optional.ofNullable(this.ccAddresses).orElseGet(ArrayList::new);
        this.bccAddresses = Optional.ofNullable(this.bccAddresses).orElseGet(ArrayList::new);
        return this;
    }
}

