/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.provider;

import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import io.fusionauth.domain.provider.GoogleApplicationConfiguration;
import io.fusionauth.domain.provider.GoogleIdentityProviderProperties;
import io.fusionauth.domain.provider.IdentityProviderLoginMethod;
import io.fusionauth.domain.provider.IdentityProviderType;
import io.fusionauth.domain.provider.SupportsPostBindings;
import io.fusionauth.domain.util.Normalizer;
import java.io.StringReader;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;

public class GoogleIdentityProvider
extends BaseIdentityProvider<GoogleApplicationConfiguration>
implements Buildable<GoogleIdentityProvider>,
SupportsPostBindings {
    public String buttonText = "Login with Google";
    public String client_id;
    public String client_secret;
    public IdentityProviderLoginMethod loginMethod;
    public GoogleIdentityProviderProperties properties = new GoogleIdentityProviderProperties("# Omit the data- prefix\nauto_prompt=true\nauto_select=false\ncancel_on_tap_outside=false\ncontext=signin\nitp_support=true", "# Omit the data- prefix\nlogo_alignment=left\nshape=rectangular\nsize=large\ntext=signin_with\ntheme=outline\ntype=standard");
    public String scope;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GoogleIdentityProvider)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GoogleIdentityProvider that = (GoogleIdentityProvider)o;
        return Objects.equals(this.buttonText, that.buttonText) && Objects.equals(this.client_id, that.client_id) && Objects.equals(this.client_secret, that.client_secret) && this.loginMethod == that.loginMethod && Objects.equals(this.properties, that.properties) && Objects.equals(this.scope, that.scope);
    }

    @Override
    public IdentityProviderType getType() {
        return IdentityProviderType.Google;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.buttonText, this.client_id, this.client_secret, this.loginMethod, this.properties, this.scope});
    }

    public Properties lookupAPIProperties(String clientId) {
        String app = this.app(clientId, (D a) -> a.properties.api);
        try {
            Properties merged = new Properties();
            merged.load(new StringReader(this.properties.api));
            if (app != null) {
                Properties override = new Properties();
                override.load(new StringReader(app));
                merged.putAll((Map<?, ?>)override);
            }
            return merged;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Properties lookupButtonProperties(String clientId) {
        String app = this.app(clientId, (D a) -> a.properties.button);
        try {
            Properties merged = new Properties();
            merged.load(new StringReader(this.properties.button));
            if (app != null) {
                Properties override = new Properties();
                override.load(new StringReader(app));
                merged.putAll((Map<?, ?>)override);
            }
            return merged;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String lookupButtonText(String clientId) {
        return this.lookup(() -> this.buttonText, () -> this.app(clientId, (D app) -> app.buttonText));
    }

    public String lookupClientId(UUID applicationId) {
        return this.lookup(() -> this.client_id, () -> this.app(applicationId, (D app) -> app.client_id));
    }

    public String lookupClientId(String clientId) {
        return this.lookup(() -> this.client_id, () -> this.app(clientId, (D app) -> app.client_id));
    }

    public String lookupClientSecret(UUID applicationId) {
        return this.lookup(() -> this.client_secret, () -> this.app(applicationId, (D app) -> app.client_secret));
    }

    public IdentityProviderLoginMethod lookupLoginMethod(String clientId) {
        return this.lookup(() -> this.loginMethod, () -> this.app(clientId, (D app) -> app.loginMethod));
    }

    public IdentityProviderLoginMethod lookupLoginMethod(UUID applicationId) {
        return this.lookup(() -> this.loginMethod, () -> this.app(applicationId, (D app) -> app.loginMethod));
    }

    public String lookupScope(String clientId) {
        return this.lookup(() -> this.scope, () -> this.app(clientId, (D app) -> app.scope));
    }

    @Override
    public void normalize() {
        super.normalize();
        if (this.properties.api != null) {
            this.properties.api = Normalizer.lineReturns(this.properties.api);
        }
        if (this.properties.button != null) {
            this.properties.button = Normalizer.lineReturns(this.properties.button);
        }
        for (GoogleApplicationConfiguration config : this.applicationConfiguration.values()) {
            if (config.properties.api != null) {
                config.properties.api = Normalizer.lineReturns(config.properties.api);
            }
            if (config.properties.button == null) continue;
            config.properties.button = Normalizer.lineReturns(config.properties.button);
        }
    }

    @Override
    public boolean postRequestEnabled() {
        return false;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

