/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.provider;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Enableable;
import io.fusionauth.domain.provider.BaseIdentityProviderApplicationConfiguration;
import io.fusionauth.domain.provider.IdentityProviderLinkingStrategy;
import io.fusionauth.domain.provider.IdentityProviderTenantConfiguration;
import io.fusionauth.domain.provider.IdentityProviderType;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;

@JsonIgnoreProperties(value={"type"}, allowGetters=true, allowSetters=false)
public abstract class BaseIdentityProvider<D extends BaseIdentityProviderApplicationConfiguration>
extends Enableable {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final Map<String, Object> data = new HashMap<String, Object>();
    public Map<UUID, D> applicationConfiguration = new HashMap<UUID, D>();
    public boolean debug;
    public UUID id;
    public ZonedDateTime insertInstant;
    public LambdaConfiguration lambdaConfiguration = new LambdaConfiguration();
    public ZonedDateTime lastUpdateInstant;
    public IdentityProviderLinkingStrategy linkingStrategy = IdentityProviderLinkingStrategy.LinkByEmail;
    public String name;
    public Map<UUID, IdentityProviderTenantConfiguration> tenantConfiguration = new HashMap<UUID, IdentityProviderTenantConfiguration>();

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseIdentityProvider)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseIdentityProvider that = (BaseIdentityProvider)o;
        return this.debug == that.debug && Objects.equals(this.data, that.data) && Objects.equals(this.applicationConfiguration, that.applicationConfiguration) && Objects.equals(this.id, that.id) && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.lambdaConfiguration, that.lambdaConfiguration) && Objects.equals(this.lastUpdateInstant, that.lastUpdateInstant) && this.linkingStrategy == that.linkingStrategy && Objects.equals(this.name, that.name) && Objects.equals(this.tenantConfiguration, that.tenantConfiguration);
    }

    public abstract IdentityProviderType getType();

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.data, this.applicationConfiguration, this.debug, this.id, this.insertInstant, this.lambdaConfiguration, this.lastUpdateInstant, this.linkingStrategy, this.name, this.tenantConfiguration});
    }

    @JsonIgnore
    public boolean inUse() {
        return this.enabled && this.applicationConfiguration.values().stream().anyMatch(c -> c.enabled);
    }

    public boolean isEnabledForApplicationId(UUID applicationId) {
        BaseIdentityProviderApplicationConfiguration configuration = (BaseIdentityProviderApplicationConfiguration)this.applicationConfiguration.get(applicationId);
        return configuration != null && configuration.enabled;
    }

    public void normalize() {
    }

    protected <R> R app(UUID applicationId, Function<D, R> app) {
        BaseIdentityProviderApplicationConfiguration config = (BaseIdentityProviderApplicationConfiguration)this.applicationConfiguration.get(applicationId);
        return config == null ? null : (R)app.apply(config);
    }

    protected <R> R app(String clientId, Function<D, R> app) {
        return this.app(this.parseUUID(clientId), app);
    }

    protected <R> R lookup(Supplier<R> global, Supplier<R> app) {
        R v = app.get();
        return v != null ? v : global.get();
    }

    protected UUID parseUUID(String clientId) {
        try {
            return UUID.fromString(clientId);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }

    public static class LambdaConfiguration {
        public UUID reconcileId;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LambdaConfiguration)) {
                return false;
            }
            LambdaConfiguration that = (LambdaConfiguration)o;
            return Objects.equals(this.reconcileId, that.reconcileId);
        }

        public int hashCode() {
            return Objects.hash(this.reconcileId);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }
}

