/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.EventInfo;
import io.fusionauth.domain.User;
import io.fusionauth.domain.connector.BaseConnectorConfiguration;
import io.fusionauth.domain.event.BaseUserEvent;
import io.fusionauth.domain.event.EventType;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import java.util.Objects;
import java.util.UUID;

public class UserLoginSuccessEvent
extends BaseUserEvent
implements Buildable<UserLoginSuccessEvent> {
    public UUID applicationId;
    public String authenticationType;
    public UUID connectorId;
    public UUID identityProviderId;
    public String identityProviderName;
    @Deprecated
    public String ipAddress;

    @JacksonConstructor
    public UserLoginSuccessEvent() {
    }

    public UserLoginSuccessEvent(EventInfo info, UUID applicationId, String authenticationType, BaseIdentityProvider<?> identityProvider, User user) {
        super(info, user);
        this.applicationId = applicationId;
        this.authenticationType = authenticationType;
        this.connectorId = BaseConnectorConfiguration.FUSIONAUTH_CONNECTOR_ID;
        this.identityProviderId = identityProvider.id;
        this.identityProviderName = identityProvider.name;
        if (info != null && info.ipAddress != null) {
            this.ipAddress = info.ipAddress;
        }
    }

    public UserLoginSuccessEvent(EventInfo info, UUID applicationId, UUID connectorId, String authenticationType, User user) {
        super(info, user);
        this.applicationId = applicationId;
        this.authenticationType = authenticationType;
        this.connectorId = connectorId;
        if (info != null && info.ipAddress != null) {
            this.ipAddress = info.ipAddress;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        UserLoginSuccessEvent that = (UserLoginSuccessEvent)o;
        return Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.authenticationType, that.authenticationType) && Objects.equals(this.connectorId, that.connectorId) && Objects.equals(this.identityProviderId, that.identityProviderId) && Objects.equals(this.identityProviderName, that.identityProviderName) && Objects.equals(this.ipAddress, that.ipAddress);
    }

    @Override
    public EventType getType() {
        return EventType.UserLoginSuccess;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.applicationId, this.authenticationType, this.connectorId, this.identityProviderId, this.identityProviderName, this.ipAddress);
    }
}

