/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.util.Normalizer;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class ApplicationOAuthScope
implements Comparable<ApplicationOAuthScope>,
Buildable<ApplicationOAuthScope> {
    public UUID applicationId;
    public Map<String, Object> data = new LinkedHashMap<String, Object>();
    public String defaultConsentDetail;
    public String defaultConsentMessage;
    public String description;
    public UUID id;
    public ZonedDateTime insertInstant;
    public ZonedDateTime lastUpdateInstant;
    public String name;
    public boolean required;

    @JacksonConstructor
    public ApplicationOAuthScope() {
    }

    public ApplicationOAuthScope(UUID id, UUID applicationId, String name) {
        this.id = id;
        this.applicationId = applicationId;
        this.name = name;
    }

    public ApplicationOAuthScope(String name) {
        this(null, null, name);
    }

    public ApplicationOAuthScope(ApplicationOAuthScope other) {
        this.applicationId = other.applicationId;
        this.data.putAll(other.data);
        this.defaultConsentDetail = other.defaultConsentDetail;
        this.defaultConsentMessage = other.defaultConsentMessage;
        this.description = other.description;
        this.id = other.id;
        this.insertInstant = other.insertInstant;
        this.lastUpdateInstant = other.lastUpdateInstant;
        this.name = other.name;
        this.required = other.required;
    }

    @Override
    public int compareTo(ApplicationOAuthScope o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationOAuthScope that = (ApplicationOAuthScope)o;
        return this.required == that.required && Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.data, that.data) && Objects.equals(this.defaultConsentDetail, that.defaultConsentDetail) && Objects.equals(this.defaultConsentMessage, that.defaultConsentMessage) && Objects.equals(this.description, that.description) && Objects.equals(this.id, that.id) && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.lastUpdateInstant, that.lastUpdateInstant) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.applicationId, this.data, this.defaultConsentDetail, this.defaultConsentMessage, this.description, this.id, this.insertInstant, this.lastUpdateInstant, this.name, this.required);
    }

    public void normalize() {
        this.defaultConsentDetail = Normalizer.trimToNull(this.defaultConsentDetail);
        this.defaultConsentMessage = Normalizer.trimToNull(this.defaultConsentMessage);
        this.description = Normalizer.trimToNull(this.description);
        this.name = Normalizer.trim(this.name);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

