/*
 * Copyright (c) 2019-2023, FusionAuth, All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package io.fusionauth.domain;

import java.util.Objects;

import com.inversoft.json.JacksonConstructor;

/**
 * Something that can be required and thus also optional. This currently extends Enableable because anything that is
 * required/optional is almost always enableable as well.
 *
 * @author Brian Pontarelli
 */
public class Requirable extends Enableable {
  public boolean required;

  @JacksonConstructor
  public Requirable() {
  }

  public Requirable(boolean enabled, boolean required) {
    this.enabled = enabled;
    this.required = required;
  }

  public Requirable(Requirable other) {
    this.enabled = other.enabled;
    this.required = other.required;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof Requirable)) {
      return false;
    }
    if (!super.equals(o)) {
      return false;
    }
    Requirable that = (Requirable) o;
    return required == that.required;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), required);
  }
}
